/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import com.unclezs.novel.analyzer.request.proxy.HttpProxy;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;

public final class ProxyUtils {
    public static final String SYSTEM_PROXIES = "java.net.useSystemProxies";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String GOOGLE = "https://www.google.com";
    private static final ProxySelector DEFAULT_SELECTOR;
    private static final HttpProxySelector SYSTEM_PROXY_SELECTOR;
    private static List<Proxy> proxies;

    public static void setEnabledAppProxy(boolean enabled) {
        proxies = enabled ? List.of(ProxyUtils.getHttpProxy()) : List.of(Proxy.NO_PROXY);
        SYSTEM_PROXY_SELECTOR.setEnabledAppProxy(enabled);
    }

    public static void setEnabledSystemProxy(boolean enabled) {
        SYSTEM_PROXY_SELECTOR.setEnabledSystemProxy(enabled);
    }

    public static void setHttpProxyHost(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            System.clearProperty(HTTP_PROXY_HOST);
        } else {
            System.setProperty(HTTP_PROXY_HOST, host);
        }
    }

    public static void setHttpProxyPort(String port) {
        if (StringUtils.isBlank((CharSequence)port)) {
            System.clearProperty(HTTP_PROXY_PORT);
        } else {
            System.setProperty(HTTP_PROXY_PORT, port);
        }
    }

    public static void setHttpProxyUser(String user) {
        if (StringUtils.isBlank((CharSequence)user)) {
            System.clearProperty(HTTP_PROXY_USER);
        } else {
            System.setProperty(HTTP_PROXY_USER, user);
        }
    }

    public static void setHttpProxyPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            System.clearProperty(HTTP_PROXY_PASSWORD);
        } else {
            System.setProperty(HTTP_PROXY_PASSWORD, password);
        }
    }

    private static Proxy getHttpProxy() {
        String host = System.getProperty(HTTP_PROXY_HOST);
        String port = System.getProperty(HTTP_PROXY_PORT);
        if (StringUtils.isBlank((CharSequence)host) || StringUtils.isBlank((CharSequence)port)) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port)));
    }

    public static HttpProxy getSystemProxy() {
        Proxy proxy = DEFAULT_SELECTOR.select(URI.create(GOOGLE)).get(0);
        if (proxy != Proxy.NO_PROXY) {
            String[] s = proxy.address().toString().split(":");
            return new HttpProxy(s[0], Integer.valueOf(Integer.parseInt(s[1])));
        }
        return HttpProxy.NO_PROXY;
    }

    private ProxyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        proxies = List.of(Proxy.NO_PROXY);
        System.setProperty(SYSTEM_PROXIES, "true");
        DEFAULT_SELECTOR = ProxySelector.getDefault();
        SYSTEM_PROXY_SELECTOR = new HttpProxySelector();
        ProxySelector.setDefault(SYSTEM_PROXY_SELECTOR);
    }

    static class HttpProxySelector
    extends ProxySelector {
        private static final List<Proxy> NO_PROXY_LIST = List.of(Proxy.NO_PROXY);
        private boolean enabledAppProxy = false;
        private boolean enabledSystemProxy = false;

        HttpProxySelector() {
        }

        @Override
        public List<Proxy> select(URI uri) {
            if (this.enabledSystemProxy) {
                return DEFAULT_SELECTOR.select(uri);
            }
            if (this.enabledAppProxy) {
                return proxies;
            }
            return NO_PROXY_LIST;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            DEFAULT_SELECTOR.connectFailed(uri, sa, ioe);
        }

        public void setEnabledAppProxy(boolean enabledAppProxy) {
            this.enabledAppProxy = enabledAppProxy;
        }

        public void setEnabledSystemProxy(boolean enabledSystemProxy) {
            this.enabledSystemProxy = enabledSystemProxy;
        }
    }
}

