/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import com.unclezs.novel.app.framework.exception.IoRuntimeException;
import com.unclezs.novel.app.framework.exception.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static URL url(String location) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
        if (resource == null) {
            log.error("\u8d44\u6e90\u672a\u627e\u5230: {}", (Object)location);
            throw new ResourceNotFoundException("\u8d44\u6e90\u672a\u627e\u5230: ".concat(location));
        }
        return resource;
    }

    public static boolean exist(String location) {
        return null != Thread.currentThread().getContextClassLoader().getResource(location);
    }

    public static InputStream stream(String location) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (stream == null) {
            log.error("\u8d44\u6e90\u672a\u627e\u5230: {}", (Object)location);
            throw new ResourceNotFoundException("\u8d44\u6e90\u672a\u627e\u5230: ".concat(location));
        }
        return stream;
    }

    public static Properties properties(String location) {
        InputStream stream = ResourceUtils.stream(location);
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new IoRuntimeException(e);
        }
        return properties;
    }

    public static String externalForm(String location) {
        return ResourceUtils.url(location).toExternalForm();
    }
}

