/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.windows;

import com.sun.jna.platform.win32.Win32VK;
import com.tulskiy.keymaster.common.HotKey;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

class KeyMap {
    private static final Map<Integer, Integer> codeExceptions = new HashMap<Integer, Integer>(){
        {
            this.put(155, 45);
            this.put(127, 46);
            this.put(10, 13);
            this.put(44, 188);
            this.put(46, 190);
            this.put(521, 187);
            this.put(45, 189);
            this.put(47, 191);
            this.put(59, 186);
            this.put(154, 44);
        }
    };

    KeyMap() {
    }

    static int getCode(HotKey hotKey) {
        if (hotKey.isMedia()) {
            int code = 0;
            switch (hotKey.mediaKey) {
                case MEDIA_NEXT_TRACK: {
                    code = Win32VK.VK_MEDIA_NEXT_TRACK.code;
                    break;
                }
                case MEDIA_PLAY_PAUSE: {
                    code = Win32VK.VK_MEDIA_PLAY_PAUSE.code;
                    break;
                }
                case MEDIA_PREV_TRACK: {
                    code = Win32VK.VK_MEDIA_PREV_TRACK.code;
                    break;
                }
                case MEDIA_STOP: {
                    code = Win32VK.VK_MEDIA_STOP.code;
                }
            }
            return code;
        }
        KeyStroke keyStroke = hotKey.keyStroke;
        Integer code = codeExceptions.get(keyStroke.getKeyCode());
        if (code != null) {
            return code;
        }
        return keyStroke.getKeyCode();
    }

    static int getModifiers(KeyStroke keyCode) {
        String os;
        int modifiers = 0;
        if (keyCode != null) {
            if ((keyCode.getModifiers() & 0x40) != 0) {
                modifiers |= 4;
            }
            if ((keyCode.getModifiers() & 0x80) != 0) {
                modifiers |= 2;
            }
            if ((keyCode.getModifiers() & 0x100) != 0) {
                modifiers |= 8;
            }
            if ((keyCode.getModifiers() & 0x200) != 0) {
                modifiers |= 1;
            }
        }
        if ((os = System.getProperty("os.version", "")).compareTo("6.1") >= 0) {
            modifiers |= 0x4000;
        }
        return modifiers;
    }
}

