/*
 * Decompiled with CFR 0.152.
 */
package com.tulskiy.keymaster.windows;

import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinUser;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.MediaKey;
import com.tulskiy.keymaster.common.Provider;
import com.tulskiy.keymaster.windows.KeyMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsProvider
extends Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsProvider.class);
    private static volatile int idSeq = 0;
    private boolean listen;
    private Boolean reset = false;
    private final Object lock = new Object();
    private Thread thread;
    private Map<Integer, HotKey> hotKeys = new HashMap<Integer, HotKey>();
    private Queue<HotKey> registerQueue = new LinkedList<HotKey>();

    @Override
    public void init() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Starting Windows global hotkey provider");
                WinUser.MSG msg = new WinUser.MSG();
                WindowsProvider.this.listen = true;
                while (WindowsProvider.this.listen) {
                    Object hotKey;
                    while (User32.INSTANCE.PeekMessage(msg, null, 0, 0, 1)) {
                        if (msg.message != 786) continue;
                        int id = msg.wParam.intValue();
                        hotKey = (HotKey)WindowsProvider.this.hotKeys.get(id);
                        if (hotKey == null) continue;
                        WindowsProvider.this.fireEvent((HotKey)hotKey);
                    }
                    Object object = WindowsProvider.this.lock;
                    synchronized (object) {
                        if (WindowsProvider.this.reset.booleanValue()) {
                            LOGGER.info("Reset hotkeys");
                            for (Integer id : WindowsProvider.this.hotKeys.keySet()) {
                                User32.INSTANCE.UnregisterHotKey(null, id.intValue());
                            }
                            WindowsProvider.this.hotKeys.clear();
                            WindowsProvider.this.reset = false;
                            WindowsProvider.this.lock.notify();
                        }
                        while (!WindowsProvider.this.registerQueue.isEmpty()) {
                            hotKey = (HotKey)WindowsProvider.this.registerQueue.poll();
                            if (((HotKey)hotKey).isUnregister()) {
                                WindowsProvider.this.unregister((HotKey)hotKey);
                                continue;
                            }
                            WindowsProvider.this.register((HotKey)hotKey);
                        }
                        try {
                            WindowsProvider.this.lock.wait(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                LOGGER.info("Exit listening thread");
            }
        };
        this.thread = new Thread(runnable);
        this.thread.start();
    }

    private void register(HotKey hotKey) {
        int id = idSeq++;
        int code = KeyMap.getCode(hotKey);
        if (User32.INSTANCE.RegisterHotKey(null, id, KeyMap.getModifiers(hotKey.keyStroke), code)) {
            LOGGER.info("Registering hotkey: " + hotKey);
            this.hotKeys.put(id, hotKey);
        } else {
            LOGGER.warn("Could not register hotkey: " + hotKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(KeyStroke keyCode, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(keyCode, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(MediaKey mediaKey, HotKeyListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(mediaKey, listener));
        }
    }

    private void unregister(HotKey hotKey) {
        this.hotKeys.entrySet().removeIf(regHotKey -> {
            boolean matches = hotKey.hasSameTrigger((HotKey)regHotKey.getValue());
            if (matches && !User32.INSTANCE.UnregisterHotKey(null, ((Integer)regHotKey.getKey()).intValue())) {
                LOGGER.warn("Could not unregister hotkey: " + hotKey);
            }
            return matches;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(KeyStroke keyCode) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(keyCode, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(MediaKey mediaKey) {
        Object object = this.lock;
        synchronized (object) {
            this.registerQueue.add(new HotKey(mediaKey, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            try {
                this.lock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stop() {
        this.listen = false;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        super.stop();
    }
}

