/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.common.concurrent;

import com.unclezs.novel.analyzer.common.concurrent.factory.DaemonThreadFactory;
import com.unclezs.novel.analyzer.common.concurrent.reject.BlockRejectHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadPoolExecutor GLOBAL_THREAD_POOL = ThreadUtils.newCachedThreadPool("global");

    public static void execute(Runnable task) {
        GLOBAL_THREAD_POOL.execute(task);
    }

    public static Thread newThread(Runnable runnable, boolean daemon) {
        Thread thread = GLOBAL_THREAD_POOL.getThreadFactory().newThread(runnable);
        thread.setDaemon(daemon);
        return thread;
    }

    public static void sleep(long time) {
        try {
            Thread.currentThread().join(time);
        }
        catch (InterruptedException e) {
            log.error("sleep error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static <T> Future<T> execute(Callable<T> task) {
        return GLOBAL_THREAD_POOL.submit(task);
    }

    public static ThreadPoolExecutor newSingleThreadExecutor(String name) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(name));
    }

    public static ThreadPoolExecutor newFixedThreadPoolExecutor(int threadNum, String name) {
        return new ThreadPoolExecutor(threadNum, threadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory(name));
    }

    public static ThreadPoolExecutor newBlockCallThreadPool(int threadNum, String name) {
        return new ThreadPoolExecutor(threadNum, threadNum, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory(name), BlockRejectHandler.me());
    }

    public static ThreadPoolExecutor newCachedThreadPool(String name) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory(name));
    }

    public static int getSystemActiveThreadCount() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup.activeCount();
    }

    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

