/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.common.page;

import com.unclezs.novel.analyzer.common.page.Pageable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageable<T>
implements Pageable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageable.class);
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final Set<String> visited = new HashSet<String>(16);
    private final Lock loadLock = new ReentrantLock();
    private int page;
    private Consumer<T> onNewItemAddHandler;
    private boolean hasMore;
    private boolean ignoreError = true;

    public AbstractPageable() {
        this.init();
    }

    public void setOnNewItemAddHandler(Consumer<T> onNewItemAddHandler) {
        this.onNewItemAddHandler = onNewItemAddHandler;
    }

    protected abstract String getUniqueId(T var1);

    protected abstract boolean loadPage(int var1) throws IOException;

    protected void firstLoad() throws IOException {
        this.init();
        this.loadMore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadMore() throws IOException {
        if (!this.hasMore()) {
            return;
        }
        if (this.loadLock.tryLock()) {
            try {
                block7: {
                    ++this.page;
                    try {
                        this.hasMore = this.loadPage(this.page);
                    }
                    catch (IOException e) {
                        if (this.ignoreError) break block7;
                        --this.page;
                        throw new IOException(e);
                    }
                }
                if (this.hasMore) return;
                this.cancel();
                return;
            }
            finally {
                this.loadLock.unlock();
            }
        }
        log.trace("\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7b49\u5f85\u52a0\u8f7d\u7ed3\u675f\u540e\u518d\u8bd5");
    }

    public void loadAll() throws IOException {
        while (this.hasMore()) {
            if (this.isCanceled()) continue;
            this.loadMore();
        }
    }

    protected boolean addItem(T item) {
        if (!this.isCanceled() && this.visited.add(this.getUniqueId(item))) {
            if (this.onNewItemAddHandler != null) {
                this.onNewItemAddHandler.accept(item);
            }
            return true;
        }
        return false;
    }

    protected boolean addItems(List<T> items) {
        boolean hasNew = false;
        for (T item : items) {
            if (!this.addItem(item)) continue;
            hasNew = true;
        }
        return !this.isCanceled() && hasNew;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    protected void addVisited(String uniqueId) {
        this.visited.add(uniqueId);
    }

    protected boolean isVisited(String uniqueId) {
        return this.visited.contains(uniqueId);
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    protected void init() {
        this.page = 0;
        this.visited.clear();
        this.canceled.set(false);
        this.hasMore = true;
        if (this.loadLock.tryLock()) {
            this.loadLock.unlock();
        }
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }
}

