/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core;

import com.unclezs.novel.analyzer.core.helper.AnalyzerHelper;
import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.matcher.Matchers;
import com.unclezs.novel.analyzer.core.matcher.matchers.text.DefaultContentMatcher;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.model.DetailRule;
import com.unclezs.novel.analyzer.core.model.SearchRule;
import com.unclezs.novel.analyzer.core.model.TocRule;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.HttpMethod;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.spider.helper.SearchHelper;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.util.BeanUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NovelMatcher {
    private static final Logger log = LoggerFactory.getLogger(NovelMatcher.class);

    public static String content(String originalText, ContentRule rule) {
        if (ContentRule.isEffective(rule)) {
            return Matchers.match((Object)originalText, rule.getContent());
        }
        return DefaultContentMatcher.matching(originalText);
    }

    public static List<Chapter> toc(String originalText, TocRule rule) {
        if (TocRule.isEffective(rule)) {
            Map<String, CommonRule> childRuleMap = Matchers.getChildMap(rule.getList().getType(), rule, false, "url", "name");
            return Matchers.matchList(originalText, rule.getList(), childRuleMap, Chapter.class);
        }
        Document document = Jsoup.parse((String)originalText);
        Object aTags = document.body().select("a");
        if (rule != null && Boolean.TRUE.equals(rule.getFilter())) {
            aTags = AnalyzerHelper.filterImpuritiesElements((List<Element>)aTags);
        }
        return aTags.stream().map(aTag -> new Chapter(aTag.text(), aTag.attr("href"))).collect(Collectors.toList());
    }

    public static Novel details(String originalText, DetailRule rule) {
        Novel matchedNovel;
        Novel novel = new Novel();
        if (rule != null && rule.isEffective() && (matchedNovel = Matchers.matchMultiple(originalText, Matchers.getChildMap(rule), Novel.class)) != null) {
            novel = matchedNovel;
        }
        if (StringUtils.isBlank(novel.getTitle())) {
            novel.setTitle(AnalyzerHelper.siteTitle(originalText));
        }
        novel.trim();
        return novel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Novel> search(int page, String keyword, AnalyzerRule rule, Consumer<Novel> itemHandler) throws IOException {
        SearchRule searchRule = rule.getSearch();
        ArrayList<Novel> novels = new ArrayList<Novel>();
        if (searchRule == null || !searchRule.isEffective()) {
            DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u641c\u7d22\u89c4\u5219\u65e0\u6548\uff0c\u505c\u6b62\u641c\u7d22", new Object[0]);
            return novels;
        }
        RequestParams params = searchRule.getParams().copy();
        String baseUrl = params.getUrl();
        SearchHelper.pretreatmentSearchParam(params, page, keyword);
        String originalText = SpiderHelper.request(rule.getParams(), params);
        try {
            CommonRule listRule = searchRule.getList();
            Map<String, CommonRule> childRuleMap = Matchers.getChildMap(listRule.getType(), searchRule.getDetail());
            Matchers.matchList(originalText, listRule, element -> {
                CommonRule detailPageRule = searchRule.getDetailPage();
                try {
                    Novel novel;
                    if (CommonRule.hasRule(detailPageRule)) {
                        DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u5df2\u542f\u7528\u81ea\u5b9a\u4e49\u8be6\u60c5\u9875", new Object[0]);
                        detailPageRule.setType(listRule.getType());
                        String detailPageUrl = Matchers.match(element, detailPageRule);
                        detailPageUrl = UrlUtils.completeUrl(baseUrl, detailPageUrl);
                        params.setUrl(detailPageUrl);
                        DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u81ea\u5b9a\u4e49\u8be6\u60c5\u9875\u5730\u5740\uff1a{}, \u91c7\u7528GET\u8bf7\u6c42\u83b7\u53d6\u8be6\u60c5\u9875", detailPageUrl);
                        params.setMethod(HttpMethod.GET.name());
                        String detailOriginalText = SpiderHelper.request(rule.getParams(), params);
                        HashMap<String, CommonRule> detailPage = new HashMap<String, CommonRule>(16);
                        HashMap<String, CommonRule> searchPage = new HashMap<String, CommonRule>(16);
                        childRuleMap.forEach((k, v) -> {
                            if ("search".equals(v.getPage())) {
                                searchPage.put((String)k, (CommonRule)v);
                            } else {
                                detailPage.put((String)k, (CommonRule)v);
                            }
                        });
                        novel = Matchers.matchMultiple(element, searchPage, Novel.class);
                        Novel detail = Matchers.matchMultiple(detailOriginalText, detailPage, Novel.class);
                        if (novel != null) {
                            BeanUtils.copy(detail, novel);
                        } else if (detail != null) {
                            novel = detail;
                        }
                    } else {
                        novel = Matchers.matchMultiple(element, childRuleMap, Novel.class);
                    }
                    if (novel == null) {
                        return;
                    }
                    novel.competeUrl(baseUrl);
                    novel.trim();
                    if (itemHandler != null) {
                        itemHandler.accept(novel);
                    }
                    novel.setSite(rule.getSite());
                    novels.add(novel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            log.error("\u5c0f\u8bf4\u641c\u7d22\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)keyword, (Object)e);
        }
        finally {
            ScriptContext.remove();
        }
        return novels;
    }

    private NovelMatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

