/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.helper;

import com.unclezs.novel.analyzer.core.matcher.Matchers;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jsoup.nodes.Element;

public final class AnalyzerHelper {
    public static void completeUrl(String baseUrl, Supplier<String> getter, Consumer<String> setter) {
        String url = getter.get();
        if (StringUtils.isNotBlank(url)) {
            setter.accept(UrlUtils.completeUrl(baseUrl, url));
        }
    }

    public static String renameChapter(String name, int order) {
        name = StringUtils.remove(name, "[0-9]", "\u7b2c.*?\u7ae0");
        return String.format("\u7b2c%s\u7ae0 %s", order, name);
    }

    public static String siteTitle(String originalText) {
        String titleText = RegexMatcher.me().title(originalText);
        String title = RegexMatcher.me().match(titleText, "(.{1,10}?)\u6700\u65b0##$1");
        if (StringUtils.isBlank(title)) {
            title = RegexUtils.removeNotChineseAndNotNumber(titleText);
        }
        return StringUtils.removeInvalidSymbol(title);
    }

    public static String formatContent(String content) {
        content = StringUtils.indentation(content);
        content = StringUtils.htmlBlank(content);
        return content;
    }

    public static String nextPage(String content, CommonRule nextPageRule, String baseUri) {
        if (nextPageRule != null && nextPageRule.isEffective()) {
            String next = Matchers.match((Object)content, nextPageRule);
            if (UrlUtils.isHttpUrl(next)) {
                return next;
            }
            return UrlUtils.completeUrl(baseUri, next);
        }
        return "";
    }

    public static List<Element> filterImpuritiesElements(List<Element> aTags) {
        if (CollectionUtils.isNotEmpty(aTags)) {
            HashMap results = new HashMap(aTags.size() / 2);
            for (Element element : aTags) {
                String url = element.attr("href");
                if (!StringUtils.isNotBlank(url)) continue;
                int features = element.parents().size() + (element.hasText() ? 1 : 0);
                AnalyzerHelper.computeUrlFeatures(results, features, url, element);
            }
            return AnalyzerHelper.getFeaturesResult(results);
        }
        return aTags;
    }

    public static List<Chapter> filterImpuritiesChapters(List<Chapter> chapters) {
        if (CollectionUtils.isNotEmpty(chapters)) {
            HashMap results = new HashMap(chapters.size() / 2);
            for (Chapter chapter : chapters) {
                String url = chapter.getUrl();
                if (!StringUtils.isNotBlank(url)) continue;
                AnalyzerHelper.computeUrlFeatures(results, 0, url, chapter);
            }
            return AnalyzerHelper.getFeaturesResult(results);
        }
        return chapters;
    }

    private static <T> void computeUrlFeatures(Map<Integer, List<T>> results, int features, String url, T item) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String[] parts = url.split("/");
        features += parts.length;
        if (parts.length > 1) {
            String prefix = parts[parts.length - 2];
            String suffix = parts[parts.length - 1];
            features += prefix.hashCode() + RegexUtils.getStringType(suffix);
        } else {
            features += RegexUtils.getStringType(url);
        }
        results.computeIfAbsent(features, k -> new ArrayList()).add(item);
    }

    private static <T> List<T> getFeaturesResult(Map<Integer, List<T>> results) {
        int resultFeatures = 0;
        int resultNumber = 0;
        for (Map.Entry<Integer, List<T>> entry : results.entrySet()) {
            if (entry.getValue().size() < resultNumber) continue;
            resultFeatures = entry.getKey();
            resultNumber = entry.getValue().size();
        }
        return results.get(resultFeatures);
    }

    private AnalyzerHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

