/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.helper;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.helpers.MessageFormatter;

public final class DebugHelper {
    public static boolean showSource = false;
    public static boolean enabled = false;
    private static final Set<Consumer<String>> OBSERVERS = new HashSet<Consumer<String>>();

    public static void debug(String pattern, Object ... args) {
        if (!DebugHelper.enabled()) {
            return;
        }
        String message = MessageFormatter.arrayFormat((String)pattern, (Object[])args).getMessage();
        OBSERVERS.forEach(stringConsumer -> stringConsumer.accept(message + "\n"));
    }

    public static void subscribe(Consumer<String> consumer) {
        OBSERVERS.add(consumer);
        enabled = !OBSERVERS.isEmpty();
    }

    public static void unsubscribe(Consumer<String> consumer) {
        OBSERVERS.remove(consumer);
        enabled = !OBSERVERS.isEmpty();
    }

    public static boolean enabled() {
        return enabled && !OBSERVERS.isEmpty();
    }

    private DebugHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

