/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.unclezs.novel.analyzer.core.matcher.MatcherManager;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.core.rule.ReplaceRule;
import com.unclezs.novel.analyzer.model.Pair;
import com.unclezs.novel.analyzer.util.BeanUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleHelper {
    private static final Logger log = LoggerFactory.getLogger(RuleHelper.class);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(CommonRule.class, (Object)new CommonRule()).registerTypeAdapter(ReplaceRule.class, (Object)new ReplaceRule()).registerTypeAdapter(ContentRule.class, (Object)new ContentRule()).disableHtmlEscaping().setPrettyPrinting().create();
    private static final Map<String, AnalyzerRule> RULES = new HashMap<String, AnalyzerRule>();
    private static Consumer<List<AnalyzerRule>> onRuleChangeListener;

    public static AnalyzerRule getRule(String url) {
        String host = UrlUtils.getHost(url);
        return RULES.get(host);
    }

    public static AnalyzerRule removeRule(AnalyzerRule rule) {
        String host = UrlUtils.getHost(rule.getSite());
        return RULES.remove(host);
    }

    public static AnalyzerRule getOrDefault(String url) {
        AnalyzerRule rule = RuleHelper.getRule(url);
        if (rule == null) {
            rule = new AnalyzerRule();
            rule.setSite(UrlUtils.getSite(url));
        }
        return rule;
    }

    public static AnalyzerRule rule(String url) {
        AnalyzerRule rule = RuleHelper.getRule(url);
        if (rule == null) {
            rule = new AnalyzerRule();
            String host = UrlUtils.getHost(url);
            rule.setSite(url);
            rule.setName(host);
            RuleHelper.addRule(rule);
        }
        return rule;
    }

    public static List<AnalyzerRule> rules() {
        return new ArrayList<AnalyzerRule>(RULES.values());
    }

    public static int loadRules(String ruleJson) {
        List<AnalyzerRule> rules = RuleHelper.parseRules(ruleJson, AnalyzerRule.class);
        return RuleHelper.setRules(rules);
    }

    public static int setRules(List<AnalyzerRule> rules) {
        RULES.clear();
        RuleHelper.addRule(rules);
        return rules.size();
    }

    public static void addRule(AnalyzerRule rule) {
        RuleHelper.addRule(Collections.singletonList(rule));
    }

    public static void addRule(List<AnalyzerRule> rules) {
        rules.forEach(rule -> RULES.put(UrlUtils.getHost(rule.getSite()), (AnalyzerRule)rule));
        if (onRuleChangeListener != null) {
            onRuleChangeListener.accept(RuleHelper.rules());
        }
    }

    public static void setRuleType(String type, Object ruleObj) {
        BeanUtils.getFields(ruleObj.getClass()).stream().filter(field -> field.getType().isAssignableFrom(CommonRule.class)).forEach(field -> {
            try {
                CommonRule rule = (CommonRule)field.get(ruleObj);
                if (rule != null) {
                    rule.setType(type);
                }
            }
            catch (IllegalAccessException e) {
                log.error("\u8bbe\u7f6e\u89c4\u5219\u7c7b\u578b\u5931\u8d25: field:{} - type:{}", new Object[]{field.getName(), type, e});
            }
        });
    }

    public static <T> List<T> parseRules(String ruleJson, Class<T> clazz) {
        return (List)GSON.fromJson(ruleJson, new ParameterizedTypeImpl<T>(clazz));
    }

    public static <T> T parseRule(String ruleJson, Class<T> clazz) {
        return (T)GSON.fromJson(ruleJson, clazz);
    }

    public static Pair<String, String> parseRuleType(String rule) {
        if (rule == null) {
            return null;
        }
        Pair<String, String> rulePair = null;
        for (String alias : MatcherManager.aliased()) {
            if (!rule.startsWith(alias)) continue;
            rulePair = new Pair<String, String>();
            rulePair.setLeft(alias);
            if (!MatcherManager.isDefaultAlias(alias)) {
                rulePair.setRight(rule.substring(alias.length()));
                break;
            }
            rulePair.setRight(rule);
            break;
        }
        return rulePair;
    }

    private RuleHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setOnRuleChangeListener(Consumer<List<AnalyzerRule>> onRuleChangeListener) {
        RuleHelper.onRuleChangeListener = onRuleChangeListener;
    }

    private static class ParameterizedTypeImpl<T>
    implements ParameterizedType {
        Class<T> clazz;

        public ParameterizedTypeImpl(Class<T> clz) {
            this.clazz = clz;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.clazz};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

