/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.helper;

import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.model.TocRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.model.Verifiable;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.spider.SearchSpider;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.RandomUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleTester {
    private static final Logger log = LoggerFactory.getLogger(RuleTester.class);
    public static final String LINE = "============================";
    private static final String NEW_LINE = "============================".concat("\n").concat("============================").concat("\n");
    private AnalyzerRule rule;
    private NovelSpider spider;
    private Consumer<String> messageConsumer = System.out::print;
    private boolean showAllData;
    private boolean showRule;

    public RuleTester(AnalyzerRule rule) {
        this(rule, null);
    }

    public RuleTester(AnalyzerRule rule, Consumer<String> messageConsumer) {
        this.init(rule, messageConsumer);
    }

    public void init(AnalyzerRule rule, Consumer<String> messageConsumer) {
        this.rule = rule;
        this.spider = new NovelSpider(rule);
        if (messageConsumer != null) {
            this.messageConsumer = messageConsumer;
        }
    }

    public void test(String keyword) {
        List<Novel> novels = this.search(keyword);
        if (!novels.isEmpty()) {
            List<Chapter> toc;
            Novel novel = RandomUtils.randomEle(novels);
            String tocUrl = novel.getUrl();
            this.messageConsumer.accept(NEW_LINE);
            this.messageConsumer.accept(String.format("\u9009\u62e9\u7b2c%d\u672c\u5c0f\u8bf4\u6d4b\u8bd5\u76ee\u5f55\u89e3\u6790:", novels.indexOf(novel) + 1).concat("\n"));
            this.printNovel(novel);
            if (UrlUtils.isHttpUrl(tocUrl) && !(toc = this.toc(tocUrl)).isEmpty()) {
                Chapter chapter = RandomUtils.randomEle(toc);
                this.messageConsumer.accept(NEW_LINE);
                this.messageConsumer.accept(String.format("\u9009\u62e9\u7b2c%d\u7ae0\u6d4b\u8bd5\u6b63\u6587\u53ca\u8be6\u60c5\u89e3\u6790:", toc.indexOf(chapter) + 1).concat("\n"));
                String url = chapter.getUrl();
                this.content(url);
                this.detail(url);
            }
        }
        this.printFooter("\u5168\u90e8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void content(String url) {
        String type = "\u6b63\u6587\u89e3\u6790";
        try {
            DebugHelper.subscribe(this.messageConsumer);
            ContentRule contentRule = this.rule.getContent();
            this.printHeader(type, contentRule);
            AtomicInteger page = new AtomicInteger(0);
            this.spider.content(url, str -> {
                str = StringUtils.nullToEmpty(str);
                this.messageConsumer.accept(String.format("\u3010\u6b63\u6587\u3011\uff1a\u7b2c%d\u9875\u89e3\u6790\u5b8c\u6210\uff0c\u5171%d\u5b57\uff0c\u7ed3\u679c\u5982\u4e0b\uff1a", page.incrementAndGet(), str.trim().length()));
                this.messageConsumer.accept("\n============================\n");
                if (this.showAllData) {
                    this.messageConsumer.accept(str + "\n");
                } else {
                    String[] split = str.trim().split("\n");
                    if (split.length > 0) {
                        this.messageConsumer.accept(split[0] + "\n");
                        this.messageConsumer.accept(split[split.length - 1] + "\n");
                    }
                }
            });
            this.printFooter(type, page.get());
        }
        catch (Exception e) {
            this.printError(type, e);
        }
        finally {
            DebugHelper.unsubscribe(this.messageConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Chapter> toc(String url) {
        String type = "\u76ee\u5f55\u89e3\u6790";
        try {
            DebugHelper.subscribe(this.messageConsumer);
            TocRule tocRule = this.rule.getToc();
            this.printHeader(type, tocRule);
            if (tocRule == null || !tocRule.isEffective()) {
                this.messageConsumer.accept("\u76ee\u5f55\u89c4\u5219\u65e0\u6548\uff0c\u91c7\u7528\u81ea\u52a8\u89e3\u6790\u6a21\u5f0f!!");
            }
            AtomicInteger page = new AtomicInteger(0);
            ArrayList<Chapter> toc = new ArrayList<Chapter>();
            this.spider.toc(url, chapters -> {
                if (CollectionUtils.isNotEmpty(chapters)) {
                    this.messageConsumer.accept(String.format("\u3010\u76ee\u5f55\u3011\uff1a\u7b2c%d\u9875\u89e3\u6790\u5b8c\u6210\uff0c\u5171%d\u7ae0\uff0c\u7ed3\u679c\u5982\u4e0b\uff1a", page.incrementAndGet(), chapters.size()));
                    this.messageConsumer.accept("\n============================\n");
                    StringJoiner chapterJoiner = new StringJoiner("\n");
                    if (!this.showAllData && chapters.size() > 2) {
                        this.printChapter(chapterJoiner, url, (Chapter)chapters.get(0));
                        this.printChapter(chapterJoiner, url, (Chapter)chapters.get(chapters.size() - 1));
                    } else {
                        chapters.forEach(chapter -> this.printChapter(chapterJoiner, url, (Chapter)chapter));
                    }
                    this.messageConsumer.accept(chapterJoiner.toString().concat("\n"));
                }
                toc.addAll((Collection<Chapter>)chapters);
            });
            this.messageConsumer.accept("\n\u7ae0\u8282\u6293\u53d6\u5b8c\u6210\uff0c\u5171\uff1a" + toc.size() + "\u7ae0" + "\n");
            this.printFooter(type, page.get());
            ArrayList<Chapter> arrayList = toc;
            return arrayList;
        }
        catch (Exception e) {
            this.printError(type, e);
        }
        finally {
            DebugHelper.unsubscribe(this.messageConsumer);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Novel> search(String keyword) {
        String type = "\u641c\u7d22";
        try {
            DebugHelper.subscribe(this.messageConsumer);
            this.printHeader(type, this.rule.getSearch());
            ArrayList<Novel> novelList = new ArrayList<Novel>();
            SearchSpider searchSpider = new SearchSpider(Collections.singletonList(this.rule));
            searchSpider.setPageConsumer(pageNovels -> {
                this.messageConsumer.accept(String.format("\u3010\u641c\u7d22\u3011\uff1a\u7b2c%d\u9875\u641c\u7d22\u5b8c\u6210\uff0c\u5171%d\u672c\uff0c\u7ed3\u679c\u5982\u4e0b\uff1a", searchSpider.getPage(), pageNovels.size()));
                this.messageConsumer.accept("\n============================\n");
                if (!this.showAllData && pageNovels.size() > 2) {
                    this.printNovel((Novel)pageNovels.get(0));
                    this.printNovel((Novel)pageNovels.get(pageNovels.size() - 1));
                } else {
                    pageNovels.forEach(this::printNovel);
                }
                this.printPage(type, searchSpider.getPage());
                novelList.addAll((Collection<Novel>)pageNovels);
            });
            searchSpider.search(keyword);
            searchSpider.loadAll();
            this.messageConsumer.accept("\n\u5168\u90e8\u641c\u7d22\u5b8c\u6210\uff0c\u5171\uff1a" + novelList.size() + "\u672c" + "\n");
            this.printFooter(type, searchSpider.getPage() - 1);
            ArrayList<Novel> arrayList = novelList;
            return arrayList;
        }
        catch (Exception e) {
            this.printError(type, e);
        }
        finally {
            DebugHelper.unsubscribe(this.messageConsumer);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detail(String url) {
        String type = "\u8be6\u60c5\u89e3\u6790";
        try {
            DebugHelper.subscribe(this.messageConsumer);
            this.printHeader(type, this.rule.getDetail());
            Novel novel = this.spider.details(url);
            this.printNovel(novel);
            this.printFooter(type);
        }
        catch (Exception e) {
            this.printError(type, e);
        }
        finally {
            DebugHelper.unsubscribe(this.messageConsumer);
        }
    }

    private void printPage(String type, int page) {
        StringJoiner pageRecorder = new StringJoiner("\n").add("\n").add(LINE).add(String.format("%s\u7b2c%d\u9875\u5b8c\u6210", type, page)).add(LINE).add("\n");
        this.messageConsumer.accept(pageRecorder.toString());
    }

    private void printChapter(StringJoiner chapterJoiner, String url, Chapter chapter) {
        if (StringUtils.isNotBlank(chapter.getUrl())) {
            chapter.setUrl(UrlUtils.completeUrl(url, chapter.getUrl()));
        }
        chapterJoiner.add("\u540d\u79f0\uff1a" + chapter.getName()).add("\u94fe\u63a5\uff1a" + chapter.getUrl()).add(LINE);
    }

    private void printHeader(String type, Verifiable rule) {
        StringJoiner recorder = new StringJoiner("\n").add(LINE).add(String.format("%s\u6d4b\u8bd5\u5f00\u59cb\uff1a", type));
        if (this.showRule) {
            recorder.add("\u89c4\u5219\uff1a").add(GsonUtils.PRETTY.toJson((Object)rule));
        }
        recorder.add("\n");
        this.messageConsumer.accept(recorder.toString());
    }

    private void printFooter(String type) {
        this.printFooter(type, -1);
    }

    private void printFooter(String type, int page) {
        String message = type + "\u6d4b\u8bd5\u5df2\u7ecf\u5b8c\u6210\uff01\uff01";
        if (page > 0) {
            message = message + String.format(", \u5171%s\u9875", page);
        }
        StringJoiner recorder = new StringJoiner("\n").add(LINE).add(message).add(LINE).add("\n");
        this.messageConsumer.accept(recorder.toString());
    }

    private void printError(String type, Exception error) {
        StringJoiner recorder = new StringJoiner("\n").add(LINE).add(String.format("%s\u6d4b\u8bd5\u51fa\u73b0\u9519\u8bef\uff1a", type)).add(ExceptionUtils.getStackTrace((Throwable)error)).add(LINE).add("\n");
        error.printStackTrace();
        this.messageConsumer.accept(recorder.toString());
    }

    private void printNovel(Novel novel) {
        if (novel == null) {
            return;
        }
        StringJoiner novelJoiner = new StringJoiner("\n").add("\u4e66\u540d\uff1a" + novel.getTitle()).add("\u4f5c\u8005\uff1a" + novel.getAuthor()).add("\u64ad\u97f3\uff1a" + novel.getBroadcast()).add("\u94fe\u63a5\uff1a" + novel.getUrl()).add("\u5206\u7c7b\uff1a" + novel.getCategory()).add("\u5c01\u9762\uff1a" + novel.getCoverUrl()).add("\u4ecb\u7ecd\uff1a" + novel.getIntroduce()).add("\u6700\u65b0\u7ae0\u8282\u540d\u79f0\uff1a" + novel.getLatestChapterName()).add("\u5b57\u6570\uff1a" + novel.getWordCount()).add("\u66f4\u65b0\u72b6\u6001\uff1a" + novel.getState()).add("\u66f4\u65b0\u65f6\u95f4\uff1a" + novel.getUpdateTime()).add(LINE.concat("\n"));
        this.messageConsumer.accept(novelJoiner.toString());
    }

    public boolean isShowSource() {
        return DebugHelper.showSource;
    }

    public void setShowSource(boolean showSource) {
        DebugHelper.showSource = showSource;
    }

    public void setRule(AnalyzerRule rule) {
        this.rule = rule;
    }

    public void setSpider(NovelSpider spider) {
        this.spider = spider;
    }

    public void setMessageConsumer(Consumer<String> messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    public void setShowAllData(boolean showAllData) {
        this.showAllData = showAllData;
    }

    public void setShowRule(boolean showRule) {
        this.showRule = showRule;
    }

    public AnalyzerRule getRule() {
        return this.rule;
    }

    public NovelSpider getSpider() {
        return this.spider;
    }

    public Consumer<String> getMessageConsumer() {
        return this.messageConsumer;
    }

    public boolean isShowAllData() {
        return this.showAllData;
    }

    public boolean isShowRule() {
        return this.showRule;
    }
}

