/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher;

import com.unclezs.novel.analyzer.common.cache.WeakCache;

public class MatcherAlias {
    private static WeakCache<String, MatcherAlias> aliasCaches = new WeakCache();
    private String name;
    private boolean isDefault;

    private MatcherAlias(String name, boolean isDefault) {
        this.name = name;
        this.isDefault = isDefault;
    }

    public static MatcherAlias defaultAlias(String name) {
        return MatcherAlias.create(name, true);
    }

    public static MatcherAlias alias(String name) {
        return MatcherAlias.create(name, false);
    }

    public static MatcherAlias create(String name, boolean isDefault) {
        MatcherAlias alias = aliasCaches.get(name);
        if (alias != null) {
            return alias;
        }
        alias = new MatcherAlias(name, isDefault);
        aliasCaches.put(name, alias);
        return alias;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatcherAlias)) {
            return false;
        }
        MatcherAlias other = (MatcherAlias)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MatcherAlias;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefault() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "MatcherAlias(name=" + this.getName() + ", isDefault=" + this.isDefault() + ")";
    }
}

