/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMatcher
implements Matcher {
    private static final Logger log = LoggerFactory.getLogger(JsonMatcher.class);
    private static final JsonMatcher ME = new JsonMatcher();

    private JsonMatcher() {
    }

    public static JsonMatcher me() {
        return ME;
    }

    @Override
    public MatcherAlias[] aliases() {
        return new MatcherAlias[]{MatcherAlias.alias("json"), MatcherAlias.alias("json".concat(":")), MatcherAlias.defaultAlias("$.")};
    }

    @Override
    public <E> List<E> list(String src, CommonRule listRule) {
        if (StringUtils.isBlank(src)) {
            return new ArrayList();
        }
        JsonArray matchedList = (JsonArray)JsonPath.parse((String)src).read(listRule.getRule(), new Predicate[0]);
        ArrayList<JsonElement> items = new ArrayList<JsonElement>();
        for (JsonElement element : matchedList) {
            items.add(element);
        }
        return items;
    }

    @Override
    public <E> String one(E element, String rule) {
        if (element == null) {
            return null;
        }
        if (element instanceof String) {
            return this.match((String)element, rule);
        }
        return this.match(GsonUtils.toJson(element), rule);
    }

    public String match(String src, String rule) {
        try {
            src = StringUtils.removeQuote(src);
            Object ret = JsonPath.parse((String)src).read(rule, new Predicate[0]);
            if (ret != null) {
                return StringUtils.removeQuote(ret.toString());
            }
        }
        catch (PathNotFoundException e) {
            log.trace("JsonPath\u672a\u5339\u914d\u5230\uff1a{}", (Object)e.getMessage());
            return "";
        }
        return "";
    }

    static {
        final GsonJsonProvider gsonJsonProvider = new GsonJsonProvider();
        GsonMappingProvider mappingProvider = new GsonMappingProvider();
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults((MappingProvider)mappingProvider){
            final /* synthetic */ MappingProvider val$mappingProvider;
            {
                this.val$mappingProvider = mappingProvider;
            }

            public JsonProvider jsonProvider() {
                return gsonJsonProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }

            public MappingProvider mappingProvider() {
                return this.val$mappingProvider;
            }
        });
    }
}

