/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers;

import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Pair;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import java.util.List;

public class RegexMatcher
implements Matcher {
    public static final String REGEX_TEMPLATE_DELIMITER = "##";
    public static final String REGEX_PREFIX = "regex".concat(":");
    private static final RegexMatcher ME = new RegexMatcher();
    private static final String TITLE_REGEX = "<title>([\\s\\S]+?)</title>##$1";

    private RegexMatcher() {
    }

    public static RegexMatcher me() {
        return ME;
    }

    public static Pair<String, String> getTemplate(String regex) {
        String[] ret = regex.split(REGEX_TEMPLATE_DELIMITER);
        Pair<String, String> pair = Pair.of(ret[0], "$0");
        if (ret.length > 1) {
            pair.setRight(ret[1]);
        }
        return pair;
    }

    @Override
    public MatcherAlias[] aliases() {
        return new MatcherAlias[]{MatcherAlias.alias(REGEX_PREFIX), MatcherAlias.alias("regex")};
    }

    @Override
    public <E> List<E> list(String src, CommonRule listRule) {
        if (StringUtils.isBlank(src)) {
            return null;
        }
        Pair<String, String> rulePair = RegexMatcher.getTemplate(listRule.getRule());
        return RegexUtils.findAllByTemplate(rulePair.getLeft(), (CharSequence)src, rulePair.getRight());
    }

    @Override
    public <E> String one(E element, String rule) {
        if (element == null) {
            return null;
        }
        String source = StringUtils.toStringNullToEmpty(element);
        return this.match(source, rule);
    }

    public String match(String src, String regex, int index) {
        String ret = RegexUtils.get(regex, (CharSequence)src, index);
        return ret == null ? "" : ret;
    }

    public String match(String src, String rule) {
        Pair<String, String> pair = RegexMatcher.getTemplate(rule);
        String ret = RegexUtils.findByTemplate(pair.getLeft(), (CharSequence)src, pair.getRight());
        return ret == null ? "" : ret;
    }

    public String title(String content) {
        return this.one(content, TITLE_REGEX);
    }

    public String titleWithoutNumber(String content) {
        return RegexUtils.removeNotChineseAndNotNumber(this.title(content));
    }
}

