/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers;

import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.util.List;
import java.util.Objects;
import org.seimicrawler.xpath.JXDocument;
import org.seimicrawler.xpath.JXNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpathMatcher
implements Matcher {
    private static final Logger log = LoggerFactory.getLogger(XpathMatcher.class);
    private static final XpathMatcher ME = new XpathMatcher();

    private XpathMatcher() {
    }

    public static XpathMatcher me() {
        return ME;
    }

    @Override
    public MatcherAlias[] aliases() {
        return new MatcherAlias[]{MatcherAlias.alias("xpath".concat(":")), MatcherAlias.alias("xpath"), MatcherAlias.defaultAlias("//")};
    }

    @Override
    public <E> List<E> list(String src, CommonRule listRule) {
        if (StringUtils.isBlank(src)) {
            return null;
        }
        List nodes = JXDocument.create((String)src).selN(listRule.getRule());
        return nodes;
    }

    @Override
    public <E> String one(E element, String rule) {
        if (element == null) {
            return null;
        }
        if (element instanceof JXDocument) {
            return this.match((JXDocument)element, rule);
        }
        if (element instanceof JXNode) {
            return this.match((JXNode)element, rule);
        }
        return this.match(element.toString(), rule);
    }

    public String match(String src, String rule) {
        return this.match(JXDocument.create((String)src), rule);
    }

    public String match(JXDocument src, String rule) {
        List results = src.selN(rule);
        boolean selectText = rule.toLowerCase().endsWith("text()");
        if (results != null) {
            StringBuilder result = new StringBuilder();
            for (JXNode node : results) {
                if (node.isElement()) {
                    result.append(node.asElement().text());
                } else {
                    result.append(node);
                }
                if (!selectText) break;
                if (results.size() <= 1) continue;
                result.append("\r\n");
            }
            return result.toString();
        }
        return "";
    }

    public String match(JXNode src, String rule) {
        JXNode ret = src.selOne(rule);
        if (ret != null) {
            return Objects.toString(ret);
        }
        return "";
    }
}

