/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers.text;

import com.unclezs.novel.analyzer.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParagraphContentMatcher {
    private static final Pattern PATTERN = Pattern.compile("([^/][\\s\\S]*?>)([\\s\\S]*?)(<)", 2);
    private static final String PARAGRAPH = "[\\s\\S]*?[^\u5b57\\w<*][\\u4E00-\\u9FFF]+[\\s\\S]*?";
    private static final String PARAGRAPH_SECONDARY = "[\\s\\S]*?[^\u5b57\\w<*][\\u4E00-\\u9FFF]+[\\s\\S]*?";
    private static final String[] EFFECTIVE_TAG = new String[]{"br />", "br/>", "br>", "abc\">", "p>", "v>", "->"};

    private ParagraphContentMatcher() {
    }

    public static String matching(String originalText) {
        StringBuilder content = new StringBuilder();
        Matcher matcher = PATTERN.matcher(originalText);
        while (matcher.find()) {
            String tag = matcher.group(1);
            String paragraph = StringUtils.htmlBlank(matcher.group(2));
            if (!StringUtils.isNotBlank(paragraph) || !ParagraphContentMatcher.isParagraph(paragraph) || !StringUtils.endWith(tag, EFFECTIVE_TAG)) continue;
            content.append(paragraph).append("\n");
        }
        return content.toString();
    }

    private static boolean isParagraph(String paragraph) {
        return paragraph.matches("[\\s\\S]*?[^\u5b57\\w<*][\\u4E00-\\u9FFF]+[\\s\\S]*?") || paragraph.matches("[\\s\\S]*?[^\u5b57\\w<*][\\u4E00-\\u9FFF]+[\\s\\S]*?");
    }
}

