/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Verifiable;
import com.unclezs.novel.analyzer.request.RequestParams;
import java.io.Serializable;
import java.lang.reflect.Type;

public class ContentRule
implements Verifiable,
Serializable,
JsonDeserializer<ContentRule> {
    private static final long serialVersionUID = -1810410696732782893L;
    private Boolean enableNext;
    private Boolean removeTitle;
    private Long delayTime;
    private Boolean traditionToSimple;
    private RequestParams params;
    private CommonRule content = CommonRule.create("auto", "1");
    private CommonRule next = CommonRule.create("xpath", "//a[text()~='.*?\u4e0b[\u4e00]{0,1}[\u9875\u8282].*']/@href");

    public static boolean isEffective(ContentRule rule) {
        return rule != null && CommonRule.isEffective(rule.getContent());
    }

    public boolean isAllowNextPage() {
        return Boolean.TRUE.equals(this.enableNext) && CommonRule.isEffective(this.next);
    }

    @Override
    public boolean isEffective() {
        return true;
    }

    public ContentRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ContentRule contentRule = new ContentRule();
        if (json.isJsonObject()) {
            JsonElement paramsElement;
            JsonElement nextElement;
            JsonElement contentElement;
            JsonElement delayTimeElement;
            JsonElement removeTitleElement;
            JsonElement traditionToSimpleElement;
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement enableNextElement = jsonObject.get("enableNext");
            if (enableNextElement != null) {
                contentRule.setEnableNext(enableNextElement.getAsBoolean());
            }
            if ((traditionToSimpleElement = jsonObject.get("traditionToSimple")) != null) {
                contentRule.setTraditionToSimple(traditionToSimpleElement.getAsBoolean());
            }
            if ((removeTitleElement = jsonObject.get("removeTitle")) != null) {
                contentRule.setRemoveTitle(removeTitleElement.getAsBoolean());
            }
            if ((delayTimeElement = jsonObject.get("delayTime")) != null) {
                contentRule.setDelayTime(delayTimeElement.getAsLong());
            }
            if ((contentElement = jsonObject.get("content")) != null) {
                contentRule.setContent((CommonRule)context.deserialize(contentElement, CommonRule.class));
            }
            if ((nextElement = jsonObject.get("next")) != null) {
                contentRule.setNext((CommonRule)context.deserialize(nextElement, CommonRule.class));
            }
            if ((paramsElement = jsonObject.get("params")) != null) {
                contentRule.setParams((RequestParams)context.deserialize(paramsElement, RequestParams.class));
            }
        } else {
            contentRule.setContent(CommonRule.create(json.getAsString()));
        }
        return contentRule;
    }

    public Boolean getEnableNext() {
        return this.enableNext;
    }

    public Boolean getRemoveTitle() {
        return this.removeTitle;
    }

    public Long getDelayTime() {
        return this.delayTime;
    }

    public Boolean getTraditionToSimple() {
        return this.traditionToSimple;
    }

    public RequestParams getParams() {
        return this.params;
    }

    public CommonRule getContent() {
        return this.content;
    }

    public CommonRule getNext() {
        return this.next;
    }

    public void setEnableNext(Boolean enableNext) {
        this.enableNext = enableNext;
    }

    public void setRemoveTitle(Boolean removeTitle) {
        this.removeTitle = removeTitle;
    }

    public void setDelayTime(Long delayTime) {
        this.delayTime = delayTime;
    }

    public void setTraditionToSimple(Boolean traditionToSimple) {
        this.traditionToSimple = traditionToSimple;
    }

    public void setParams(RequestParams params) {
        this.params = params;
    }

    public void setContent(CommonRule content) {
        this.content = content;
    }

    public void setNext(CommonRule next) {
        this.next = next;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentRule)) {
            return false;
        }
        ContentRule other = (ContentRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableNext = this.getEnableNext();
        Boolean other$enableNext = other.getEnableNext();
        if (this$enableNext == null ? other$enableNext != null : !((Object)this$enableNext).equals(other$enableNext)) {
            return false;
        }
        Boolean this$removeTitle = this.getRemoveTitle();
        Boolean other$removeTitle = other.getRemoveTitle();
        if (this$removeTitle == null ? other$removeTitle != null : !((Object)this$removeTitle).equals(other$removeTitle)) {
            return false;
        }
        Long this$delayTime = this.getDelayTime();
        Long other$delayTime = other.getDelayTime();
        if (this$delayTime == null ? other$delayTime != null : !((Object)this$delayTime).equals(other$delayTime)) {
            return false;
        }
        Boolean this$traditionToSimple = this.getTraditionToSimple();
        Boolean other$traditionToSimple = other.getTraditionToSimple();
        if (this$traditionToSimple == null ? other$traditionToSimple != null : !((Object)this$traditionToSimple).equals(other$traditionToSimple)) {
            return false;
        }
        RequestParams this$params = this.getParams();
        RequestParams other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        CommonRule this$content = this.getContent();
        CommonRule other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        CommonRule this$next = this.getNext();
        CommonRule other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableNext = this.getEnableNext();
        result = result * 59 + ($enableNext == null ? 43 : ((Object)$enableNext).hashCode());
        Boolean $removeTitle = this.getRemoveTitle();
        result = result * 59 + ($removeTitle == null ? 43 : ((Object)$removeTitle).hashCode());
        Long $delayTime = this.getDelayTime();
        result = result * 59 + ($delayTime == null ? 43 : ((Object)$delayTime).hashCode());
        Boolean $traditionToSimple = this.getTraditionToSimple();
        result = result * 59 + ($traditionToSimple == null ? 43 : ((Object)$traditionToSimple).hashCode());
        RequestParams $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        CommonRule $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        CommonRule $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    public String toString() {
        return "ContentRule(enableNext=" + this.getEnableNext() + ", removeTitle=" + this.getRemoveTitle() + ", delayTime=" + this.getDelayTime() + ", traditionToSimple=" + this.getTraditionToSimple() + ", params=" + this.getParams() + ", content=" + this.getContent() + ", next=" + this.getNext() + ")";
    }
}

