/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.rule;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.model.Pair;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class ReplaceRule
implements Serializable,
JsonDeserializer<ReplaceRule>,
JsonSerializer<ReplaceRule> {
    private static final long serialVersionUID = 830391532687585985L;
    private String from;
    private String to;

    public static ReplaceRule getRule(Object replaceRules) {
        Map purify = (Map)replaceRules;
        return ReplaceRule.getRule(purify);
    }

    public static ReplaceRule getRule(Map<String, Object> purify) {
        String regex = StringUtils.toString(purify.get("from"));
        if (StringUtils.isNotEmpty(regex)) {
            String template = StringUtils.toString(purify.get("to"));
            return new ReplaceRule(regex, template);
        }
        return null;
    }

    public static ReplaceRule parseRule(String rule) {
        ReplaceRule replaceRule = new ReplaceRule();
        Pair<String, String> pair = RegexMatcher.getTemplate(rule);
        replaceRule.setFrom(pair.getLeft());
        replaceRule.setTo("$0".equals(pair.getRight()) ? "" : pair.getRight());
        return replaceRule;
    }

    public ReplaceRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            ReplaceRule replaceRule = new ReplaceRule();
            JsonObject ruleObject = json.getAsJsonObject();
            replaceRule.setFrom(GsonUtils.getOrDefault(ruleObject, "from", null));
            replaceRule.setTo(GsonUtils.getOrDefault(ruleObject, "to", null));
            return replaceRule;
        }
        return null;
    }

    public JsonElement serialize(ReplaceRule rule, Type type, JsonSerializationContext jsonSerializationContext) {
        if (StringUtils.isBlank(rule.getFrom())) {
            return null;
        }
        return new JsonPrimitive(rule.getFrom() + "##" + rule.getTo());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceRule that = (ReplaceRule)o;
        return Objects.equals(this.from, that.from);
    }

    public int hashCode() {
        return Objects.hash(this.from);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String toString() {
        return "ReplaceRule(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }

    public ReplaceRule(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public ReplaceRule() {
    }
}

