/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.model;

import com.unclezs.novel.analyzer.core.helper.AnalyzerHelper;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class Novel
implements Serializable {
    private String site;
    private String url;
    private String title;
    private String author;
    private String broadcast;
    private String category;
    private String wordCount;
    private String introduce;
    private String latestChapterName;
    private String latestChapterUrl;
    private String coverUrl;
    private String state;
    private String updateTime;
    private transient List<Chapter> chapters;

    public void competeUrl(String baseUrl) {
        AnalyzerHelper.completeUrl(baseUrl, this::getCoverUrl, this::setCoverUrl);
        AnalyzerHelper.completeUrl(baseUrl, this::getUrl, this::setUrl);
        AnalyzerHelper.completeUrl(baseUrl, this::getLatestChapterUrl, this::setLatestChapterUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Novel novel = (Novel)o;
        return Objects.equals(this.url, novel.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public void trim() {
        if (this.title != null) {
            this.title = StringUtils.trim(this.title);
        }
        if (this.author != null) {
            this.author = StringUtils.trim(this.author);
        }
        if (this.broadcast != null) {
            this.broadcast = StringUtils.trim(this.broadcast);
        }
        if (this.category != null) {
            this.category = StringUtils.trim(this.category);
        }
        if (this.wordCount != null) {
            this.wordCount = StringUtils.trim(this.wordCount);
        }
        if (this.introduce != null) {
            this.introduce = StringUtils.trim(this.introduce);
        }
        if (this.latestChapterName != null) {
            this.latestChapterName = StringUtils.trim(this.latestChapterName);
        }
        if (this.state != null) {
            this.state = StringUtils.trim(this.state);
        }
        if (this.updateTime != null) {
            this.updateTime = StringUtils.trim(this.updateTime);
        }
    }

    public String getSite() {
        return this.site;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getCategory() {
        return this.category;
    }

    public String getWordCount() {
        return this.wordCount;
    }

    public String getIntroduce() {
        return this.introduce;
    }

    public String getLatestChapterName() {
        return this.latestChapterName;
    }

    public String getLatestChapterUrl() {
        return this.latestChapterUrl;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public String getState() {
        return this.state;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public List<Chapter> getChapters() {
        return this.chapters;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setBroadcast(String broadcast) {
        this.broadcast = broadcast;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setWordCount(String wordCount) {
        this.wordCount = wordCount;
    }

    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }

    public void setLatestChapterName(String latestChapterName) {
        this.latestChapterName = latestChapterName;
    }

    public void setLatestChapterUrl(String latestChapterUrl) {
        this.latestChapterUrl = latestChapterUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setChapters(List<Chapter> chapters) {
        this.chapters = chapters;
    }

    public String toString() {
        return "Novel(site=" + this.getSite() + ", url=" + this.getUrl() + ", title=" + this.getTitle() + ", author=" + this.getAuthor() + ", broadcast=" + this.getBroadcast() + ", category=" + this.getCategory() + ", wordCount=" + this.getWordCount() + ", introduce=" + this.getIntroduce() + ", latestChapterName=" + this.getLatestChapterName() + ", latestChapterUrl=" + this.getLatestChapterUrl() + ", coverUrl=" + this.getCoverUrl() + ", state=" + this.getState() + ", updateTime=" + this.getUpdateTime() + ", chapters=" + this.getChapters() + ")";
    }
}

