/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request;

import com.unclezs.novel.analyzer.AnalyzerManager;
import com.unclezs.novel.analyzer.request.MediaType;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.proxy.DefaultProxyProvider;
import com.unclezs.novel.analyzer.request.spi.HttpProvider;
import com.unclezs.novel.analyzer.request.spi.ProxyProvider;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http {
    private static final Logger LOG;
    private static final ProxyProvider PROXY_PROVIDER;
    private static HttpProvider dynamicHttpClient;
    private static HttpProvider staticHttpClient;

    public static String content(RequestParams requestParams) throws IOException {
        Http.initDefaultRequestParams(requestParams);
        try {
            String content = Http.client(requestParams).content(requestParams);
            return Http.scriptPreHandle(requestParams, content);
        }
        catch (IOException e) {
            Http.proxyFailed(requestParams);
            throw new IOException(e);
        }
    }

    public static String get(String url, boolean dynamic) {
        RequestParams requestParams = RequestParams.builder().dynamic(dynamic).url(url).build();
        try {
            return Http.content(requestParams);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String get(String url) {
        return Http.get(url, false);
    }

    public static byte[] bytes(RequestParams requestParams) throws IOException {
        Http.initDefaultRequestParams(requestParams);
        try {
            return Http.client(requestParams).bytes(requestParams);
        }
        catch (IOException e) {
            Http.proxyFailed(requestParams);
            throw new IOException(e);
        }
    }

    public static boolean validate(RequestParams requestParams) throws IOException {
        Http.initDefaultRequestParams(requestParams);
        try {
            return Http.client(requestParams).validate(requestParams);
        }
        catch (IOException e) {
            Http.proxyFailed(requestParams);
            throw new IOException(e);
        }
    }

    private static HttpProvider client(RequestParams params) {
        if (Boolean.TRUE.equals(params.getDynamic())) {
            return dynamicHttpClient;
        }
        return staticHttpClient;
    }

    private static void proxyFailed(RequestParams requestParams) {
        if (Boolean.TRUE.equals(requestParams.getAutoProxy())) {
            PROXY_PROVIDER.removeProxy(requestParams.getProxy());
        }
    }

    private static void initDefaultRequestParams(RequestParams requestParams) {
        if (Boolean.TRUE.equals(requestParams.getAutoProxy()) && AnalyzerManager.me().isAutoProxy()) {
            requestParams.setProxy(PROXY_PROVIDER.getProxy());
        }
        if (requestParams.getMediaType() == null) {
            requestParams.setMediaType(MediaType.NONE.getMediaType());
        }
        if ("auto".equals(requestParams.getHeader("Referer"))) {
            requestParams.setHeader("Referer", requestParams.getUrl());
        }
        requestParams.addHeader("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36");
    }

    private static String scriptPreHandle(RequestParams params, String source) {
        if (Boolean.FALSE.equals(params.getDynamic()) && StringUtils.isNotBlank(params.getScript())) {
            String string;
            try {
                ScriptContext.put("source", source);
                ScriptContext.put("url", params.getUrl());
                ScriptContext.put("params", params);
                string = ScriptUtils.execute(params.getScript(), ScriptContext.current());
            }
            catch (Throwable e) {
                try {
                    LOG.error("\u9884\u5904\u7406\u811a\u672c\u6267\u884c\u5931\u8d25:{},url:{}", new Object[]{params.getScript(), params.getUrl(), e});
                }
                catch (Throwable throwable) {
                    ScriptContext.remove("source", "url", "params");
                    throw throwable;
                }
                ScriptContext.remove("source", "url", "params");
            }
            ScriptContext.remove("source", "url", "params");
            return string;
        }
        return source;
    }

    private Http() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static HttpProvider getDynamicHttpClient() {
        return dynamicHttpClient;
    }

    public static HttpProvider getStaticHttpClient() {
        return staticHttpClient;
    }

    static {
        ServiceLoader<ProxyProvider> proxyProviders;
        Iterator<ProxyProvider> proxyProviderIterator;
        LOG = LoggerFactory.getLogger(Http.class);
        ServiceLoader<HttpProvider> httpProviders = ServiceLoader.load(HttpProvider.class);
        for (HttpProvider provider : httpProviders) {
            if (provider.isDynamic()) {
                dynamicHttpClient = provider;
                continue;
            }
            staticHttpClient = provider;
        }
        if (dynamicHttpClient == null) {
            try {
                dynamicHttpClient = (HttpProvider)Class.forName("com.unclezs.novel.analyzer.request.phantomjs.PhantomJsClient").newInstance();
            }
            catch (Exception e) {
                LOG.error("\u672a\u914d\u7f6e\u52a8\u6001\u7f51\u9875\u5ba2\u6237\u7aef\uff0c\u5e76\u4e14\u52a0\u8f7d\u9ed8\u8ba4\u5ba2\u6237\u7aefPhantomJsClient\u5931\u8d25 :com.unclezs.novel.analyzer.request.phantomjs.PhantomJsClient", (Throwable)e);
            }
        }
        if (staticHttpClient == null) {
            try {
                staticHttpClient = (HttpProvider)Class.forName("com.unclezs.novel.analyzer.request.okhttp.OkHttpClient").newInstance();
            }
            catch (Exception e) {
                LOG.error("\u672a\u914d\u7f6e\u9759\u6001\u6001\u7f51\u9875\u5ba2\u6237\u7aef\uff0c\u5e76\u4e14\u52a0\u8f7d\u9ed8\u8ba4\u5ba2\u6237\u7aefOkHttpClient\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u5df2\u7ecf\u5f15\u5165Okhttp\u4f9d\u8d56 : com.unclezs.novel.analyzer.request.okhttp.OkHttpClient", (Throwable)e);
            }
        }
        PROXY_PROVIDER = (proxyProviderIterator = (proxyProviders = ServiceLoader.load(ProxyProvider.class)).iterator()).hasNext() ? proxyProviderIterator.next() : new DefaultProxyProvider();
    }
}

