/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request.okhttp;

import com.unclezs.novel.analyzer.common.exception.RequestFailedException;
import com.unclezs.novel.analyzer.request.HttpConfig;
import com.unclezs.novel.analyzer.request.HttpMethod;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.spi.HttpProvider;
import com.unclezs.novel.analyzer.request.ssl.SslTrustAllCerts;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.io.IoUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClient
implements HttpProvider {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClient.class);
    private okhttp3.OkHttpClient staticHttpClient;

    public OkHttpClient() {
        this.configuration(HttpConfig.defaultConfig());
    }

    public void configuration(HttpConfig config) {
        SslTrustAllCerts sslTrustAllCerts = new SslTrustAllCerts();
        SSLSocketFactory sslSocketFactory = this.createSslSocketFactory(sslTrustAllCerts);
        this.staticHttpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDuration(), TimeUnit.SECONDS)).connectTimeout(config.getConnectionTimeout(), TimeUnit.SECONDS).readTimeout(config.getReadTimeout(), TimeUnit.SECONDS).sslSocketFactory(sslSocketFactory, (X509TrustManager)sslTrustAllCerts).hostnameVerifier((requestedHost, remoteServerSession) -> requestedHost.equalsIgnoreCase(remoteServerSession.getPeerHost())).followRedirects(config.isFollowRedirect()).retryOnConnectionFailure(config.isRetryOnFailed()).build();
    }

    private SSLSocketFactory createSslSocketFactory(X509TrustManager manager) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{manager}, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception ignored) {
            log.warn("SSL Factory \u521b\u5efa\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684SSL Factory");
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    public Call init(RequestParams params) {
        Request.Builder requestBuilder = new Request.Builder().url(params.getUrl());
        if (CollectionUtils.isNotEmpty(params.getHeaders())) {
            for (Map.Entry<String, String> header : params.getHeaders().entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        if (HttpMethod.GET.name().equalsIgnoreCase(params.getMethod())) {
            requestBuilder.get();
        } else {
            requestBuilder.method(params.getMethod(), RequestBody.create((MediaType)MediaType.parse((String)params.getMediaType()), (String)params.getBody()));
        }
        if (CollectionUtils.isNotEmpty(params.getHeaders())) {
            for (Map.Entry<String, String> entry : params.getHeaders().entrySet()) {
                requestBuilder.header(entry.getKey(), entry.getValue());
            }
        }
        if (params.isEnableProxy()) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(params.getProxy().getHost(), (int)params.getProxy().getPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            return this.staticHttpClient.newBuilder().proxy(proxy).build().newCall(requestBuilder.build());
        }
        return this.staticHttpClient.newCall(requestBuilder.build());
    }

    @Override
    public String content(RequestParams requestParams) throws IOException {
        Call request = this.init(requestParams);
        try (Response response = request.execute();){
            this.handleFailed(response);
            ResponseBody body = response.body();
            String result = "";
            if (body != null) {
                result = StringUtils.isNotBlank(requestParams.getCharset()) ? body.source().readByteString().string(Charset.forName(requestParams.getCharset())) : this.getString(body.source(), body.contentType());
            }
            String string = result;
            return string;
        }
    }

    public String get(String url) {
        RequestParams requestParams = RequestParams.builder().url(url).build();
        try {
            return this.content(requestParams);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public byte[] bytes(RequestParams requestParams) throws IOException {
        Call request = this.init(requestParams);
        try (Response response = request.execute();){
            this.handleFailed(response);
            ResponseBody body = response.body();
            if (body == null) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] byArray = IoUtils.readBytes(body.byteStream());
            return byArray;
        }
    }

    @Override
    public boolean validate(RequestParams requestParams) throws IOException {
        Call call = this.init(requestParams);
        Response response = call.execute();
        response.close();
        return response.isSuccessful();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private void handleFailed(Response response) throws IOException {
        if (!response.isSuccessful()) {
            throw new RequestFailedException("\u9519\u8bef\u7684\u72b6\u6001\u7801\uff0ccode=" + response.code() + " \uff1a" + response);
        }
    }

    private String getString(BufferedSource source, MediaType contentType) throws IOException {
        String htmlCharset;
        Charset charset = null;
        boolean isHtml = false;
        byte[] contentBytes = source.readByteArray();
        if (contentType != null && (charset = contentType.charset(null)) == null) {
            charset = Util.bomAwareCharset((BufferedSource)source, (Charset)StandardCharsets.UTF_16LE);
            isHtml = "text/html".equalsIgnoreCase(contentType.toString());
        }
        if (isHtml && StandardCharsets.UTF_16LE.equals(charset) && (htmlCharset = RegexUtils.matchHtmlCharset(new String(contentBytes, StandardCharsets.UTF_8))) != null) {
            charset = Charset.forName(htmlCharset);
        }
        if (charset == null || StandardCharsets.UTF_16LE.equals(charset)) {
            charset = Charset.forName("GBK");
        }
        return new String(contentBytes, charset);
    }

    public okhttp3.OkHttpClient getStaticHttpClient() {
        return this.staticHttpClient;
    }
}

