/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request.phantomjs;

import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.CollectionUtils;

public class PhantomJsRequestParams {
    private String url;
    private String proxy = "";
    private String userAgent = "";
    private String referer = "";
    private String cookie = "";
    private boolean loadImg = false;
    private boolean ignoreSslError = true;

    public PhantomJsRequestParams(String url) {
        this.url = url;
    }

    public static PhantomJsRequestParams from(RequestParams requestParams) {
        PhantomJsRequestParams data = new PhantomJsRequestParams(requestParams.getUrl());
        if (CollectionUtils.isNotEmpty(requestParams.getHeaders())) {
            data.setUserAgent(requestParams.getHeaders().getOrDefault("User-Agent", ""));
            data.setCookie(requestParams.getHeaders().getOrDefault("Cookie", ""));
            data.setReferer(requestParams.getHeaders().getOrDefault("Referer", ""));
        }
        if (requestParams.isEnableProxy()) {
            data.setProxy(String.format("%s:%d", requestParams.getProxy().getHost(), requestParams.getProxy().getPort()));
        }
        return data;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getCookie() {
        return this.cookie;
    }

    public boolean isLoadImg() {
        return this.loadImg;
    }

    public boolean isIgnoreSslError() {
        return this.ignoreSslError;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setLoadImg(boolean loadImg) {
        this.loadImg = loadImg;
    }

    public void setIgnoreSslError(boolean ignoreSslError) {
        this.ignoreSslError = ignoreSslError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhantomJsRequestParams)) {
            return false;
        }
        PhantomJsRequestParams other = (PhantomJsRequestParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLoadImg() != other.isLoadImg()) {
            return false;
        }
        if (this.isIgnoreSslError() != other.isIgnoreSslError()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$referer = this.getReferer();
        String other$referer = other.getReferer();
        if (this$referer == null ? other$referer != null : !this$referer.equals(other$referer)) {
            return false;
        }
        String this$cookie = this.getCookie();
        String other$cookie = other.getCookie();
        return !(this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PhantomJsRequestParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLoadImg() ? 79 : 97);
        result = result * 59 + (this.isIgnoreSslError() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $referer = this.getReferer();
        result = result * 59 + ($referer == null ? 43 : $referer.hashCode());
        String $cookie = this.getCookie();
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        return result;
    }

    public String toString() {
        return "PhantomJsRequestParams(url=" + this.getUrl() + ", proxy=" + this.getProxy() + ", userAgent=" + this.getUserAgent() + ", referer=" + this.getReferer() + ", cookie=" + this.getCookie() + ", loadImg=" + this.isLoadImg() + ", ignoreSslError=" + this.isIgnoreSslError() + ")";
    }
}

