/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.script;

import com.unclezs.novel.analyzer.common.exception.UtilException;
import com.unclezs.novel.analyzer.script.variables.Utils;
import com.unclezs.novel.analyzer.util.StringUtils;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptUtils {
    private static final Logger log = LoggerFactory.getLogger(ScriptUtils.class);
    private static final ScriptEngine SCRIPT_ENGINE = new ScriptEngineManager().getEngineByName("js");

    public static Object executeForResult(String js, Bindings runtimeVariables) {
        try {
            return runtimeVariables == null ? SCRIPT_ENGINE.eval(js) : SCRIPT_ENGINE.eval(js, runtimeVariables);
        }
        catch (Throwable e) {
            if (log.isTraceEnabled()) {
                log.trace("\u6267\u884c\u811a\u672c\u5931\u8d25\uff1ajs:{}\uff0cvars:{}", new Object[]{js, runtimeVariables, e});
            }
            throw new UtilException(e);
        }
    }

    public static String execute(String js, Bindings runtimeVariables) {
        return StringUtils.toStringNullToEmpty(ScriptUtils.executeForResult(js, runtimeVariables));
    }

    public static String execute(String js) {
        return ScriptUtils.execute(js, null);
    }

    private ScriptUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ScriptEngine getSCRIPT_ENGINE() {
        return SCRIPT_ENGINE;
    }

    static {
        Utils utils = new Utils();
        SCRIPT_ENGINE.getContext().setAttribute(utils.getVariableName(), utils, 200);
    }
}

