/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.script.variables;

import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.matcher.Matchers;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.HttpMethod;
import com.unclezs.novel.analyzer.request.MediaType;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.variables.ScriptGlobalVariables;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils
implements ScriptGlobalVariables<Utils> {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String NAME = "utils";

    @Override
    public String getVariableName() {
        return NAME;
    }

    public void log(String msg) {
        DebugHelper.debug(msg, new Object[0]);
    }

    public String get(String url) {
        return Http.get(url);
    }

    public String post(String url, String body) throws IOException {
        RequestParams params = RequestParams.builder().url(url).method(HttpMethod.POST.name()).body(body == null ? "" : body).mediaType(MediaType.JSON.getMediaType()).build();
        return Http.content(params);
    }

    public String request(String paramsJson) throws IOException {
        RequestParams params = GsonUtils.parse(paramsJson, RequestParams.class);
        if (params == null || StringUtils.isEmpty(params.getUrl())) {
            log.trace("\u8bf7\u6c42\u89e3\u6790\u5931\u8d25, \u53c2\u6570\u4e0d\u5408\u6cd5: {}.", (Object)params);
            return null;
        }
        return Http.content(params);
    }

    public String toJson(Object obj) {
        return GsonUtils.toJson(obj);
    }

    public String match(String src, String withTypeRule) {
        return Matchers.match((Object)src, withTypeRule);
    }

    public List<Object> matchList(String src, String withTypeRule) {
        return Matchers.matchList(src, CommonRule.create(withTypeRule));
    }

    public String absUrl(String baseUrl, String relativePath) {
        return UrlUtils.completeUrl(baseUrl, relativePath);
    }
}

