/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider;

import com.github.houbb.opencc4j.util.ZhConverterUtil;
import com.unclezs.novel.analyzer.core.NovelMatcher;
import com.unclezs.novel.analyzer.core.helper.AnalyzerHelper;
import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.model.DetailRule;
import com.unclezs.novel.analyzer.core.model.TocRule;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.spider.Result;
import com.unclezs.novel.analyzer.spider.TocSpider;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NovelSpider {
    private static final Logger log = LoggerFactory.getLogger(NovelSpider.class);
    private AnalyzerRule rule;

    public NovelSpider() {
    }

    public NovelSpider(AnalyzerRule rule) {
        this.rule = rule;
    }

    public String content(String url) throws IOException {
        return this.content(url, null).getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<String> content(String url, Consumer<String> pageConsumer) throws IOException {
        Set<String> visited;
        int page;
        StringBuilder contentBuilder;
        RequestParams params;
        ContentRule contentRule;
        block9: {
            contentRule = this.getRule().getContent();
            boolean audio = Boolean.TRUE.equals(this.getRule().getAudio());
            String preScript = Optional.of(contentRule).map(ContentRule::getParams).map(RequestParams::getScript).orElse(null);
            if (audio && StringUtils.isBlank(preScript) && !CommonRule.isEffective(contentRule.getContent())) {
                DebugHelper.debug("\u3010\u6b63\u6587\u3011\uff1a\u6709\u58f0\u5c0f\u8bf4\u89c4\u5219 \u5e76\u4e14 \u9884\u5904\u7406\u811a\u672c\u4e3a\u7a7a \u5e76\u4e14 \u89c4\u5219\u65e0\u6548\uff0c\u4e0d\u518d\u8bf7\u6c42\u6b63\u6587\u94fe\u63a5\uff1a{}\uff0c\u5339\u914d\u7ed3\u679c\u4e3a\u6b63\u6587\u94fe\u63a5", url);
                this.doConsumer(pageConsumer, url);
                return new Result<String>(1, url);
            }
            params = RequestParams.create(url, contentRule.getParams());
            contentBuilder = new StringBuilder();
            page = 1;
            visited = CollectionUtils.set(false, params.getUrl());
            String originalText = this.request(params);
            if (!CommonRule.isEffective(contentRule.getContent())) {
                DebugHelper.debug("\u3010\u6b63\u6587\u3011\uff1a\u6b63\u6587\u89c4\u5219\u65e0\u6548\uff0c\u5339\u914d\u7ed3\u679c\u76f4\u63a5\u4e3a {} \u7684\u6e90\u7801", url);
                this.doConsumer(pageConsumer, originalText);
                return new Result<String>(1, originalText);
            }
            try {
                String content = NovelMatcher.content(originalText, contentRule);
                contentBuilder.append(content);
                if (pageConsumer != null) {
                    pageConsumer.accept(content);
                }
                if (!Boolean.FALSE.equals(this.rule.getAudio()) || !contentRule.isAllowNextPage()) break block9;
                DebugHelper.debug("\u3010\u6b63\u6587\u3011\uff1a\u6b63\u6587\u7ffb\u9875\u5df2\u542f\u7528", new Object[0]);
                String uniqueId = RegexMatcher.me().titleWithoutNumber(originalText);
                params.setUrl(AnalyzerHelper.nextPage(originalText, contentRule.getNext(), params.getUrl()));
                while (visited.add(params.getUrl())) {
                    originalText = this.request(params);
                    String currentUniqueId = RegexMatcher.me().titleWithoutNumber(originalText);
                    if (!uniqueId.equals(currentUniqueId)) {
                        DebugHelper.debug("\u3010\u6b63\u6587\u3011\uff1a\u7f51\u9875\u6807\u9898\u4e0d\u5339\u914d\uff0c\u505c\u6b62\u7ffb\u9875\uff1a\u6b63\u786e\u7684\uff1a{} , \u4e0d\u5339\u914d\u7684\uff1a{}", uniqueId, currentUniqueId);
                        break;
                    }
                    String pageContent = NovelMatcher.content(originalText, contentRule);
                    contentBuilder.append("\n").append(pageContent);
                    this.doConsumer(pageConsumer, pageContent);
                    params.setUrl(AnalyzerHelper.nextPage(originalText, contentRule.getNext(), params.getUrl()));
                    DebugHelper.debug("\u3010\u6b63\u6587\u3011\uff1a\u83b7\u53d6\u5230\u4e0b\u4e00\u9875\u94fe\u63a5\uff1a{}\uff0c\u5f53\u524d\u9875\u7801\uff1a{}", params.getUrl(), ++page);
                }
            }
            finally {
                ScriptContext.remove();
            }
        }
        String result = contentBuilder.toString();
        if (Boolean.TRUE.equals(contentRule.getTraditionToSimple())) {
            result = ZhConverterUtil.toSimple((String)result);
        }
        log.trace("\u5c0f\u8bf4\u7ae0\u8282\u5185\u5bb9:{} \u6293\u53d6\u5b8c\u6210\uff0c\u5171{}\u9875\uff0c\u5171{}\u5b57", new Object[]{params.getUrl(), visited.size(), contentBuilder.length()});
        return new Result<String>(page, result);
    }

    public List<Chapter> toc(String url) throws IOException {
        return this.toc(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Chapter> toc(String url, Consumer<List<Chapter>> pageConsumer) throws IOException {
        List<Chapter> toc;
        Set<String> visited;
        RequestParams params;
        block6: {
            TocRule tocRule = this.getRule().getToc();
            params = RequestParams.create(url, tocRule.getParams());
            visited = CollectionUtils.set(false, params.getUrl());
            String originalText = this.request(params);
            int order = 1;
            try {
                toc = NovelMatcher.toc(originalText, tocRule);
                toc = TocSpider.pretreatmentToc(toc, params.getUrl(), tocRule, order);
                order = toc.size();
                this.doConsumer(pageConsumer, toc);
                boolean forceNext = Boolean.TRUE.equals(tocRule.getForceNext());
                DebugHelper.debug("\u3010\u76ee\u5f55\u3011\uff1a\u542f\u7528\u76ee\u5f55\u7ffb\u9875\uff1a{}\uff0c\u5f3a\u5236\u7ffb\u9875\uff1a{}", tocRule.isAllowNextPage(), forceNext);
                if (!tocRule.isAllowNextPage()) break block6;
                String uniqueId = RegexMatcher.me().titleWithoutNumber(originalText);
                params.setUrl(AnalyzerHelper.nextPage(originalText, tocRule.getNext(), params.getUrl()));
                while (visited.add(params.getUrl())) {
                    originalText = this.request(params);
                    String currentUniqueId = RegexMatcher.me().titleWithoutNumber(originalText);
                    if (!forceNext && !uniqueId.equals(currentUniqueId)) {
                        DebugHelper.debug("\u3010\u76ee\u5f55\u3011\uff1a\u7f51\u9875\u6807\u9898\u4e0d\u5339\u914d\uff0c\u4e14\u672a\u5f00\u542f\u5f3a\u5236\u7ffb\u9875\uff0c\u505c\u6b62\u7ffb\u9875\uff1a\u6b63\u786e\u7684\uff1a{} , \u4e0d\u5339\u914d\u7684\uff1a{}", uniqueId, currentUniqueId);
                        break;
                    }
                    List<Chapter> pageChapters = NovelMatcher.toc(originalText, tocRule);
                    if (CollectionUtils.isNotEmpty(pageChapters)) {
                        toc.addAll(pageChapters);
                        toc = TocSpider.pretreatmentToc(pageChapters, params.getUrl(), tocRule, order);
                        order = toc.size();
                        this.doConsumer(pageConsumer, pageChapters);
                    }
                    params.setUrl(AnalyzerHelper.nextPage(originalText, tocRule.getNext(), params.getUrl()));
                    DebugHelper.debug("\u3010\u76ee\u5f55\u3011\uff1a\u83b7\u53d6\u5230\u4e0b\u4e00\u9875\u94fe\u63a5\uff1a{}\uff0c\u5f53\u524d\u9875\u7801\uff1a{}", params.getUrl(), visited.size());
                }
            }
            finally {
                ScriptContext.remove();
            }
        }
        log.debug("\u5c0f\u8bf4\u76ee\u5f55:{} \u6293\u53d6\u5b8c\u6210\uff0c\u5171{}\u9875\uff0c{}\u7ae0\u8282", new Object[]{params.getUrl(), visited.size(), toc.size()});
        return toc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Novel details(String url) throws IOException {
        Novel novel;
        DetailRule detailRule = this.rule.getDetail();
        RequestParams params = RequestParams.create(url, detailRule.getParams());
        String originalText = this.request(params);
        try {
            novel = NovelMatcher.details(originalText, detailRule);
            novel.competeUrl(params.getUrl());
            novel.trim();
        }
        finally {
            ScriptContext.remove();
        }
        return novel;
    }

    private String request(RequestParams params) throws IOException {
        return SpiderHelper.request(this.rule.getParams(), params);
    }

    private <T> void doConsumer(Consumer<T> consumer, T param) {
        if (consumer != null) {
            consumer.accept(param);
        }
    }

    public AnalyzerRule getRule() {
        return this.rule;
    }

    public void setRule(AnalyzerRule rule) {
        this.rule = rule;
    }
}

