/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider;

import com.unclezs.novel.analyzer.common.page.AbstractPageable;
import com.unclezs.novel.analyzer.core.NovelMatcher;
import com.unclezs.novel.analyzer.core.comparator.ChapterComparator;
import com.unclezs.novel.analyzer.core.helper.AnalyzerHelper;
import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.core.model.TocRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.RandomUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocSpider
extends AbstractPageable<Chapter> {
    private static final Logger log = LoggerFactory.getLogger(TocSpider.class);
    public static final ChapterComparator CHAPTER_COMPARATOR = new ChapterComparator();
    public static final String COMPARATOR_A = "a";
    public static final String COMPARATOR_B = "b";
    private AnalyzerRule rule;
    private RequestParams params;
    private String uniqueId = "none";
    private int order = 1;
    private Novel novel;

    public TocSpider(AnalyzerRule rule) {
        this.rule = rule;
        super.setIgnoreError(false);
    }

    public static List<Chapter> pretreatmentToc(List<Chapter> toc, String baseUrl, TocRule tocRule, int order) {
        if (CollectionUtils.isNotEmpty(toc)) {
            toc = toc.stream().distinct().filter(chapter -> chapter.getUrl() != null && !chapter.getUrl().startsWith("javascript")).collect(Collectors.toList());
            if (tocRule != null) {
                if (CollectionUtils.isNotEmpty(tocRule.getBlackUrls())) {
                    List blackList = toc.stream().filter(chapter -> tocRule.getBlackUrls().contains(chapter.getUrl())).collect(Collectors.toList());
                    toc.removeAll(blackList);
                }
                if (Boolean.TRUE.equals(tocRule.getFilter())) {
                    toc = AnalyzerHelper.filterImpuritiesChapters(toc);
                }
            }
            toc.stream().filter(chapter -> !UrlUtils.isHttpUrl(chapter.getUrl())).forEach(chapter -> chapter.setUrl(UrlUtils.completeUrl(baseUrl, chapter.getUrl())));
            TocSpider.sortToc(tocRule, toc);
            if (tocRule != null && Boolean.TRUE.equals(tocRule.getReverse())) {
                Collections.reverse(toc);
            }
            for (Chapter chapter2 : toc) {
                chapter2.setOrder(order++);
            }
        }
        return toc;
    }

    public static void sortToc(TocRule tocRule, List<Chapter> toc) {
        if (tocRule == null || Boolean.FALSE.equals(tocRule.getSort())) {
            return;
        }
        if (StringUtils.isNotBlank(tocRule.getSortScript())) {
            try {
                toc.sort((o1, o2) -> {
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.put(COMPARATOR_A, o1);
                    bindings.put(COMPARATOR_B, o2);
                    return (int)Double.parseDouble(ScriptUtils.execute(tocRule.getSortScript(), bindings));
                });
            }
            catch (Exception e) {
                DebugHelper.debug("\u3010\u7ae0\u8282\u3011\uff1a\u6392\u5e8f\u5931\u8d25", new Object[0]);
                DebugHelper.debug("\u3010\u7ae0\u8282\u3011\uff1a\u5931\u8d25\u539f\u56e0\uff1a{}", e.getMessage());
            }
        } else {
            toc.sort(CHAPTER_COMPARATOR);
        }
    }

    public void toc(String url) throws IOException {
        this.order = 1;
        this.params = RequestParams.create(url, this.rule.getToc().getParams());
        super.firstLoad();
    }

    @Override
    protected String getUniqueId(Chapter item) {
        return item.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean loadPage(int page) throws IOException {
        TocRule tocRule = this.getRule().getToc();
        String originalText = SpiderHelper.request(this.rule.getParams(), this.params);
        boolean hasMore = false;
        try {
            if (page == 1) {
                this.novel = NovelMatcher.details(originalText, this.rule.getDetail());
                this.novel.setUrl(this.params.getUrl());
            }
            List<Chapter> chapters = NovelMatcher.toc(originalText, tocRule);
            chapters = TocSpider.pretreatmentToc(chapters, this.params.getUrl(), tocRule, this.order);
            if (tocRule.isAllowNextPage()) {
                String pageUniqueId = RegexMatcher.me().titleWithoutNumber(originalText);
                String nextPageUrl = AnalyzerHelper.nextPage(originalText, tocRule.getNext(), this.params.getUrl());
                hasMore = StringUtils.isNotBlank(nextPageUrl);
                if (!tocRule.isEffective()) {
                    boolean bl = hasMore = Objects.equals(pageUniqueId, this.uniqueId) || page == 1;
                }
                if (CollectionUtils.isNotEmpty(chapters)) {
                    hasMore = this.addItems(chapters) && hasMore;
                    log.trace("\u5c0f\u8bf4\u76ee\u5f55 \u7b2c{}\u9875 \u6293\u53d6\u5b8c\u6210\uff0c\u5171{}\u7ae0.", (Object)page, (Object)chapters.size());
                }
                if (hasMore) {
                    this.uniqueId = pageUniqueId;
                    this.params.setUrl(nextPageUrl);
                } else {
                    log.debug("\u5c0f\u8bf4\u76ee\u5f55:{} \u6293\u53d6\u5b8c\u6210\uff0c\u5171{}\u9875.", (Object)this.params.getUrl(), (Object)page);
                }
            } else {
                this.addItems(chapters);
            }
        }
        finally {
            ScriptContext.remove();
        }
        if (StringUtils.isBlank(this.novel.getTitle())) {
            this.novel.setTitle("\u672a\u77e5\u6807\u9898" + RandomUtils.randomInt(1000));
        }
        return hasMore;
    }

    public String getNextPageUrl() {
        return this.params.getUrl();
    }

    public AnalyzerRule getRule() {
        return this.rule;
    }

    public RequestParams getParams() {
        return this.params;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setRule(AnalyzerRule rule) {
        this.rule = rule;
    }

    public void setParams(RequestParams params) {
        this.params = params;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setNovel(Novel novel) {
        this.novel = novel;
    }

    public TocSpider() {
    }

    public Novel getNovel() {
        return this.novel;
    }
}

