/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider.helper;

import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.matcher.matchers.XpathMatcher;
import com.unclezs.novel.analyzer.core.model.Params;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpiderHelper {
    private static final Logger log = LoggerFactory.getLogger(SpiderHelper.class);
    public static final String COVER_PROVIDER_URL = "https://www.qidian.com/search?kw=";

    public static String request(Params defaultParams, RequestParams params) throws IOException {
        String content;
        params.overrideParams(defaultParams);
        try {
            ScriptContext.put("url", params.getUrl());
            ScriptContext.put("params", params);
            DebugHelper.debug("\u3010\u8bf7\u6c42\u3011\uff1a\u8bbf\u95ee\u7f51\u9875 {}", params.getUrl());
            content = Http.content(params);
            DebugHelper.debug("\u3010\u8bf7\u6c42\u3011\uff1a\u8bbf\u95ee\u6210\u529f", new Object[0]);
            if (DebugHelper.showSource) {
                DebugHelper.debug("\u3010\u8bf7\u6c42\u3011\uff1a\u6e90\u7801\u5982\u4e0b\uff1a", new Object[0]);
                DebugHelper.debug(content, new Object[0]);
            }
        }
        catch (Exception e) {
            ScriptContext.remove();
            DebugHelper.debug("\u3010\u8bf7\u6c42\u3011\uff1a\u8bbf\u95ee\u5931\u8d25", new Object[0]);
            DebugHelper.debug("\u3010\u8bf7\u6c42\u3011\uff1a\u539f\u56e0\uff1a{} ", e.getMessage());
            throw new IOException(e);
        }
        return content;
    }

    public static String request(RequestParams params) throws IOException {
        return SpiderHelper.request(null, params);
    }

    public static void mergeNovel(File dir, String filename, boolean delete) throws IOException {
        String saveFile = new File(dir.getParent(), filename).getAbsolutePath();
        FileUtils.deleteFile(saveFile);
        File[] txtFiles = dir.listFiles((dir1, name) -> name.endsWith(".txt"));
        if (txtFiles != null) {
            Arrays.stream(txtFiles).sorted((o1, o2) -> {
                Integer a = Integer.valueOf(o1.getName().split("\\.")[0]);
                Integer b = Integer.valueOf(o2.getName().split("\\.")[0]);
                return a - b;
            }).forEach(file -> {
                try {
                    String s = FileUtils.readUtf8String(file.getAbsoluteFile());
                    FileUtils.appendUtf8String(saveFile, s);
                    if (delete) {
                        FileUtils.deleteFile(file);
                    }
                }
                catch (IOException e) {
                    log.error("\u5c0f\u8bf4\u5408\u5e76\u5931\u8d25\uff1a\u6587\u4ef6\u5939\uff1a{}\uff0c\u6587\u4ef6\u540d\uff1a{}", new Object[]{dir, filename, e});
                    e.printStackTrace();
                }
            });
        }
        if (delete) {
            FileUtils.deleteFile(dir);
        }
    }

    public static String removeTitle(String src, String target) {
        String[] lines = src.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (!StringUtils.isNotBlank(lines[i])) continue;
            if (i < 3) {
                lines[i] = lines[i].replace(target, "").replace(target.replace(" ", ""), "");
            }
            sb.append(lines[i]).append("\r\n");
        }
        return sb.toString();
    }

    public static String getCover(String title) throws IOException {
        RequestParams params = RequestParams.create(COVER_PROVIDER_URL + UrlUtils.encode(title));
        String html = Http.content(params);
        String cover = XpathMatcher.me().match(html, "//*[@id=\"result-list\"]/div/ul/li[1]/div[1]/a/img/@src");
        cover = UrlUtils.completeUrl(COVER_PROVIDER_URL, cover);
        return cover;
    }

    private SpiderHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

