/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider.pipline;

import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.spider.pipline.AbstractTextPipeline;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtPipeline
extends AbstractTextPipeline {
    private static final Logger log = LoggerFactory.getLogger(TxtPipeline.class);
    private static final String DOWNLOAD_FILE_FORMAT = "%s/%d.%s.txt";
    private boolean merge;
    private boolean deleteVolume;

    @Override
    public void processChapter(Chapter chapter) {
        String filePath = String.format(DOWNLOAD_FILE_FORMAT, this.getFilePath(), chapter.getOrder(), StringUtils.removeInvalidSymbol(chapter.getName()));
        try {
            FileUtils.writeString(filePath, chapter.getContent(), this.getCharset());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u7ae0\u8282\u5185\u5bb9\u5230\uff1a{} \u5931\u8d25.", (Object)filePath, (Object)e);
        }
    }

    @Override
    public void onComplete() {
        if (this.merge) {
            try {
                SpiderHelper.mergeNovel(new File(this.getFilePath()), this.getNovel().getTitle().concat(".txt"), this.deleteVolume);
            }
            catch (Exception e) {
                log.error("\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff1a{}", (Object)this.getFilePath(), (Object)e);
            }
        }
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void setDeleteVolume(boolean deleteVolume) {
        this.deleteVolume = deleteVolume;
    }
}

