/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanUtils {
    private static final Logger log = LoggerFactory.getLogger(BeanUtils.class);

    public static <T> void copy(T src, T target) {
        if (src == null || target == null) {
            return;
        }
        Class<?> clazz = src.getClass();
        for (Field field : BeanUtils.getFields(clazz)) {
            try {
                Object srcValue = field.get(src);
                if (srcValue == null) continue;
                field.set(target, srcValue);
            }
            catch (IllegalAccessException e) {
                log.error("BeanUtils\u62f7\u8d1d\u5c5e\u6027\u5931\u8d25: {}", (Object)field.getName(), (Object)e);
            }
        }
    }

    public static <T> T mapToBean(Map<String, ?> map, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                try {
                    Field field = clazz.getDeclaredField(entry.getKey());
                    field.setAccessible(true);
                    field.set(instance, entry.getValue());
                }
                catch (NoSuchFieldException e) {
                    log.warn("\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\uff1a{} - {}", (Object)entry.getKey(), (Object)e.getMessage());
                }
            }
            return instance;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5bf9\u8c61\u5931\u8d25\uff1a{}", clazz);
            return null;
        }
    }

    public static List<Field> getFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields) {
            int mod = field.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
            field.setAccessible(true);
            fieldList.add(field);
        }
        return fieldList;
    }

    private BeanUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

