/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final String USER_DIR = System.getProperty("user.dir");

    public static void deleteFile(File file) throws IOException {
        Files.deleteIfExists(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static void deleteFile(String file) throws IOException {
        Files.deleteIfExists(Paths.get(file, new String[0]));
    }

    public static boolean exist(String path) {
        return new File(path).exists();
    }

    public static File touch(String path) throws IOException {
        return FileUtils.touch(path, "");
    }

    public static File touch(String parent, String child) throws IOException {
        File file = new File(parent, child);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                FileUtils.mkdirs(file.getParentFile().getAbsolutePath());
            }
            Files.createFile(Paths.get(parent, child), new FileAttribute[0]);
        }
        return file;
    }

    public static void mkdirs(String path) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
    }

    public static List<String> readLines(File file, String charset) throws IOException {
        return Files.readAllLines(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName(charset));
    }

    public static String readUtf8String(File file) throws IOException {
        List<String> lines = FileUtils.readLines(file, StandardCharsets.UTF_8.name());
        StringBuilder allLine = new StringBuilder();
        for (String line : lines) {
            allLine.append(line).append("\n");
        }
        return allLine.toString();
    }

    public static String readResource(String resourcePathFile) throws IOException {
        return FileUtils.readUtf8String(new File(FileUtils.class.getResource(resourcePathFile).getFile()));
    }

    public static String readUtf8String(String filePath) throws IOException {
        return FileUtils.readUtf8String(new File(filePath));
    }

    public static void writeString(File file, String content, String charset) throws IOException {
        FileUtils.writeString(file.getAbsolutePath(), content, charset);
    }

    public static void writeUtf8String(String filePath, String content) throws IOException {
        FileUtils.writeString(filePath, content, StandardCharsets.UTF_8.name());
    }

    public static void appendUtf8String(String filePath, String content) throws IOException {
        FileUtils.writeString(filePath, content, StandardCharsets.UTF_8.name(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public static void writeString(String file, String content, String charset) throws IOException {
        FileUtils.writeString(file, content, charset, StandardOpenOption.CREATE);
    }

    public static void writeString(String file, String content, String charset, OpenOption ... openOptions) throws IOException {
        FileUtils.touch(file);
        Files.write(Paths.get(file, new String[0]), Collections.singletonList(content), Charset.forName(charset), openOptions);
    }

    public static void writeBytes(String file, byte[] content) throws IOException {
        FileUtils.touch(file);
        Files.write(Paths.get(file, new String[0]), content, StandardOpenOption.CREATE);
    }

    public static void deleteForce(String s) {
        FileUtils.deleteForce(new File(s));
    }

    public static void deleteForce(File file) {
        if (file.isFile() && file.exists()) {
            boolean result = file.delete();
            int tryCount = 0;
            while (!result && tryCount++ < 10) {
                System.gc();
                result = file.delete();
            }
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

