/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

import com.unclezs.novel.analyzer.common.exception.UtilException;
import com.unclezs.novel.analyzer.util.io.FastByteArrayOutputStream;
import com.unclezs.novel.analyzer.util.io.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SerializationUtils {
    public static <T> T deepClone(T obj) {
        Object object;
        if (!(obj instanceof Serializable)) {
            return null;
        }
        FastByteArrayOutputStream byteOut = new FastByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(obj);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            object = in.readObject();
        }
        catch (Exception e) {
            try {
                throw new UtilException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
        return (T)object;
    }

    private SerializationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

