/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

import com.unclezs.novel.analyzer.util.regex.PatternPool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.helpers.MessageFormatter;

public final class StringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String EMPTY = "";
    public static final String BLANK = " ";
    public static final String NEW_LINE = "\r\n";
    public static final String LF = "\n";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "/";
    public static final String NULL = "null";
    public static final String QUOT = "\"";
    public static final String COLON = ":";
    private static final String HTML_BLANK_REG = "&[#\\w]{3,6}[;:]?";
    private static final Pattern ncrReg = Pattern.compile("&#([\\d]{2,6});");

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (StringUtils.isBlankChar(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String removeQuote(String str) {
        if (str.startsWith(QUOT) && str.endsWith(QUOT)) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static boolean startWith(String str, String ... prefix) {
        for (String pre : prefix) {
            if (str.startsWith(pre)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static String removeHeaderAndTail(String header, String tail, String src) {
        if (StringUtils.isNotEmpty(header) && src.contains(header)) {
            src = src.substring(header.length());
        }
        if (StringUtils.isNotEmpty(tail) && src.contains(tail)) {
            src = src.substring(0, src.indexOf(tail));
        }
        return src;
    }

    public static String remove(String src, String ... target) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        for (String s : target) {
            if (s == null) continue;
            src = PatternPool.get(s, 32).matcher(src).replaceAll(EMPTY);
        }
        return StringUtils.trim(src);
    }

    public static String format(String messagePattern, Object ... params) {
        return MessageFormatter.arrayFormat((String)messagePattern, (Object[])params).getMessage();
    }

    public static String removeInvalidSymbol(String str) {
        return str.replaceAll("[\\\\/:*?\"<>|]", EMPTY);
    }

    public static String trim(String text) {
        char p;
        int st;
        int len = text.length();
        char[] val = text.toCharArray();
        for (st = 0; st < len && ((p = val[st]) <= ' ' || p == '\u00a0' || p == '\u3000'); ++st) {
        }
        while (st < len && ((p = val[len - 1]) <= ' ' || p == '\u00a0' || p == '\u3000')) {
            --len;
        }
        return st > 0 || len < text.length() ? text.substring(st, len) : text;
    }

    public static String ncr2Chinese(String src) {
        src = src.replace(LF, "&#92;&#114;&#92;&#110;");
        Matcher m = ncrReg.matcher(src);
        while (m.find()) {
            src = src.replace(m.group(0), (char)Integer.parseInt(m.group(1)) + EMPTY);
        }
        return src.replace("\\r\\n", LF);
    }

    public static String htmlBlank(String html) {
        return StringUtils.replaceHtmlBlank(html, BLANK);
    }

    public static String replaceHtmlBlank(String html, String target) {
        return html.replaceAll(HTML_BLANK_REG, target);
    }

    public static boolean endWith(String src, String ... suffix) {
        for (String end : suffix) {
            if (!src.endsWith(end)) continue;
            return true;
        }
        return false;
    }

    public static String indentation(String originalText) {
        String[] paragraph = originalText.split("[\r]?\n");
        StringBuilder paragraphs = new StringBuilder();
        for (String line : paragraph) {
            if (!StringUtils.isNotBlank(line)) continue;
            paragraphs.append("    ").append(StringUtils.trim(line)).append(LF).append(LF);
        }
        return paragraphs.toString();
    }

    public static String str(CharSequence cs) {
        return null == cs ? null : cs.toString();
    }

    public static String replaceAllCaseInsensitive(String str, String replacement, String ... regexes) {
        String ret = str;
        for (String regex : regexes) {
            ret = PatternPool.get(regex, 2).matcher(ret).replaceAll(replacement);
        }
        return ret;
    }

    public static String replace(String src, String replacement, String ... str) {
        String ret = src;
        for (String s : str) {
            ret = ret.replace(s, replacement);
        }
        return ret;
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        return StringUtils.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return StringUtils.sub(string, fromIndex, string.length());
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return EMPTY;
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtils.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return StringUtils.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        if (StringUtils.isEmpty(str)) {
            return -1;
        }
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static String nullToEmpty(CharSequence str) {
        return StringUtils.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(CharSequence str, String defaultStr) {
        return str == null ? defaultStr : str.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public static String toStringNullToEmpty(Object obj) {
        if (obj == null) {
            return EMPTY;
        }
        return obj.toString();
    }

    private StringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

