/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

public final class SystemUtils {
    private static final String OS_NAME = System.getProperty("os.name", "Windows");
    private static final boolean IS_OS_MAC = SystemUtils.getOsMatches("Mac");
    private static final boolean IS_OS_WINDOWS = SystemUtils.getOsMatches("Windows");
    private static final boolean IS_OS_LINUX = SystemUtils.getOsMatches("Linux") || SystemUtils.getOsMatches("LINUX");

    public static boolean isMac() {
        return IS_OS_MAC;
    }

    private static boolean getOsMatches(String osNamePrefix) {
        if (OS_NAME == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix);
    }

    public static boolean isLinux() {
        return IS_OS_LINUX;
    }

    public static boolean isWindows() {
        return IS_OS_WINDOWS;
    }

    public static String getExecuteSuffix() {
        if (SystemUtils.isWindows()) {
            return ".exe";
        }
        return "";
    }

    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

