/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util.io;

import com.unclezs.novel.analyzer.util.io.FastByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int EOF = -1;

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int readSize;
        byte[] buffer = new byte[8192];
        long size = 0L;
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            size += (long)readSize;
            out.flush();
        }
        IoUtils.close(in);
        IoUtils.close(out);
        return size;
    }

    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        try {
            IoUtils.copy(in, out);
        }
        finally {
            if (isClose) {
                IoUtils.close(in);
            }
        }
        return out;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        return IoUtils.read(in, true).toByteArray();
    }

    public static FileInputStream toStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static FileInputStream toStream(String file) throws FileNotFoundException {
        return IoUtils.toStream(new File(file));
    }

    public static FileOutputStream toOutStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public static FileOutputStream toOutStream(String file) throws FileNotFoundException {
        return IoUtils.toOutStream(new File(file));
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private IoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

