/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util.uri;

import com.unclezs.novel.analyzer.common.exception.UtilException;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import com.unclezs.novel.analyzer.util.uri.UrlEncoder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class UrlUtils {
    public static String getRedirectUrl(String path) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(path).openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(5000);
            return conn.getHeaderField("Location");
        }
        catch (IOException e) {
            e.printStackTrace();
            return path;
        }
    }

    public static String getHost(String url) {
        return UrlUtils.isHttpUrl(url) ? RegexUtils.get("http[s]{0,1}://(.+?)/", (CharSequence)(url + "/"), 1) : url;
    }

    public static String getSite(String url) {
        String site;
        if (UrlUtils.isHttpUrl(url) && StringUtils.isNotBlank(site = RegexUtils.get("(http[s]{0,1}://.+?)/", (CharSequence)(url + "/"), 1))) {
            return site.concat("/");
        }
        return url;
    }

    public static String getDomain(String url) {
        String host = RegexUtils.get("http[s]{0,1}://(.+?)/", (CharSequence)(url + "/"), 1);
        String[] str = host.split("\\.");
        if (str.length == 3) {
            return str[1];
        }
        return str[0];
    }

    public static String getUrlNoParams(String url) {
        int index = url.indexOf("?");
        if (index < 0) {
            return url;
        }
        return url.substring(0, index);
    }

    public static String getUrlParams(String url) {
        int index = url.indexOf("?");
        if (index < 0) {
            return "";
        }
        return url.substring(index + 1);
    }

    public static String getUrlLastPathNotSuffix(String url) {
        String str = url.replaceAll("\\.htm.*", "");
        if (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        int i = str.lastIndexOf("/");
        return str.substring(i + 1);
    }

    public static boolean isHttpUrl(String url) {
        return StringUtils.isNotEmpty(url) && url.length() > 5 && "http".equalsIgnoreCase(url.substring(0, 4));
    }

    public static String completeUrl(String baseUrl, String relativePath) {
        if (StringUtils.isBlank(baseUrl = UrlUtils.normalize(baseUrl, false))) {
            return relativePath;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            return baseUrl;
        }
    }

    public static String normalize(String url, boolean isEncodePath) {
        String body;
        String protocol;
        if (StringUtils.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StringUtils.subPre(url, sepIndex + 3);
            body = StringUtils.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StringUtils.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringUtils.subSuf(body, paramsSepIndex);
            body = StringUtils.subPre(body, paramsSepIndex);
        }
        if (StringUtils.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/");
        }
        int pathSepIndex = StringUtils.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StringUtils.subPre(body, pathSepIndex);
            path = StringUtils.subSuf(body, pathSepIndex);
        }
        if (isEncodePath) {
            path = UrlUtils.encode(path);
        }
        return protocol + domain + StringUtils.nullToEmpty(path) + StringUtils.nullToEmpty(params);
    }

    public static String encode(String url) throws UtilException {
        return UrlUtils.encode(url, StandardCharsets.UTF_8);
    }

    public static String encode(String url, Charset charset) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        if (null == charset) {
            charset = StandardCharsets.UTF_8;
        }
        return UrlEncoder.encode(url, charset.displayName());
    }

    public static boolean notAnchor(String url) {
        return !url.contains("#");
    }

    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

