/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
implements Log {
    private final Logger logger;

    public Log4jLog(String className) {
        this.logger = Logger.getLogger((String)className);
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        return this.logger.isEnabledFor((Priority)this.levelToLog4jLevel(level));
    }

    @Override
    public void log(Log.Level level, String msg) {
        this.logger.log((Priority)this.levelToLog4jLevel(level), (Object)msg);
    }

    @Override
    public void log(Log.Level level, String msg, Throwable t) {
        this.logger.log((Priority)this.levelToLog4jLevel(level), (Object)msg, t);
    }

    private Level levelToLog4jLevel(Log.Level level) {
        switch (level) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case FATAL: {
                return Level.FATAL;
            }
        }
        return Level.INFO;
    }
}

