#ifndef	__HTTP_MODULE_INCLUDE_H__
#define	__HTTP_MODULE_INCLUDE_H__

#include "lib_acl.h"
#include "service_struct.h"

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef _USRDLL
# ifdef MOD_HTTP_EXPORTS
#  define MOD_HTTP_API __declspec(dllexport)
# else
#  define MOD_HTTP_API __declspec(dllimport)
# endif
#else
#  define MOD_HTTP_API
#endif

extern ACL_DLL_ENV *var_http_dll_env;
extern char *var_cfg_http_domain_allow;
extern int   var_cfg_http_client_keepalive;
extern int   var_cfg_http_server_keepalive;
extern int   var_cfg_http_domain_allow_all;
extern int   var_cfg_http_method_connect_enable;
extern int   var_cfg_http_proxy_connection_off;

/* ̬صĺӿ */

/**
 * ̬صģĳʼһ
 * @param dll_env {ACL_DLL_ENV*} ɼس򴫵ݹĻ
 * @param cfg_dir {const char*} ö̬ģļ·
 */
MOD_HTTP_API void module_service_init(ACL_DLL_ENV *dll_env, const char *cfg_dir);

/**
 * ɶ̬ģ鴴һʵԱسöԲʵ
 * @return {SERVICE*} ɶ̬ģ鴴ķʵ
 */
MOD_HTTP_API SERVICE *module_service_create(void);

/**
 * سյһͻӺô˺
 * @param service {SERVICE*}  module_service_create ķ
 * @param stream {ACL_ASTREAM*} ɼسյĿͻ첽
 */
MOD_HTTP_API void module_service_main(SERVICE *service, ACL_ASTREAM *stream);

#ifdef	__cplusplus
}
#endif

#endif
