#ifndef ACL_AQUEUE_INCLUDE_H
#define	ACL_AQUEUE_INCLUDE_H

#include "../stdlib/acl_define.h"
#include "../thread/acl_thread.h"

#ifdef __cplusplus
extern "C" {
#endif

#define	ACL_AQUEUE_ERR_UNKNOWN      -1
#define	ACL_AQUEUE_OK               0
#define	ACL_AQUEUE_ERR_LOCK         1
#define	ACL_AQUEUE_ERR_UNLOCK       2
#define	ACL_AQUEUE_ERR_TIMEOUT      3
#define	ACL_AQUEUE_ERR_COND_WAIT    4
#define	ACL_AQUEUE_ERR_COND_SIGNALE 5

typedef struct ACL_AQUEUE_ITEM ACL_AQUEUE_ITEM;
typedef struct ACL_AQUEUE ACL_AQUEUE;

typedef void (*ACL_AQUEUE_FREE_FN)(void *);
/**
 * һ¶ж
 * @return ACL_AQUEUE ṹָ
 */
ACL_API ACL_AQUEUE *acl_aqueue_new(void);

/**
 * ǷϸеߣĬΪҪиü acl_aqueue_free
 * @param queue ACL_AQUEUE ṹָ
 * @param flag 
 */
ACL_API void acl_aqueue_check_owner(ACL_AQUEUE *queue, char flag);

/**
 * öе, ֻ߲ȨͷŶ,  acl_aqueue_free()
 * @param queue ACL_AQUEUE ṹָ
 * @param owner ̺߳űʶߵID
 */
ACL_API void acl_aqueue_set_owner(ACL_AQUEUE *queue, unsigned int owner);

/**
 * ͷŶж
 * @param queue ACL_AQUEUE ṹָ
 * @param free_fn ͷŶʱ, úΪ, ڲͨ˺е
 *        ûעݶнͷ
 */
ACL_API void acl_aqueue_free(ACL_AQUEUE *queue, ACL_AQUEUE_FREE_FN free_fn);

/**
 * ӶȡһԪ, ʱ, һֱȵԪؿû
 * @param queue ACL_AQUEUE ṹָ
 * @return ûͨ acl_aqueue_push Ԫָ
 */
ACL_API void *acl_aqueue_pop(ACL_AQUEUE *queue);

/**
 * ӶȡһԪ, ʱ, һֱȵԪؿûʱ
 * @param queue ACL_AQUEUE ṹָ
 * @param tmo_sec ӶȡԪصĳʱʱ, λΪ
 * @param tmo_usec ӶȡԪصĳʱʱ, λΪ΢
 * @return ûͨ acl_aqueue_push Ԫָ
 */
ACL_API void *acl_aqueue_pop_timedwait(ACL_AQUEUE *queue, int tmo_sec, int tmo_usec);

/**
 * һԪ
 * @param queue ACL_AQUEUE ṹָ
 * @param data ûָ
 * @return {int} ӶԪǷɹ, 0: ok; < 0: error
 */
ACL_API int acl_aqueue_push(ACL_AQUEUE *queue, void *data);

/**
 * һζвĴ, define as: ACL_AQUEUE_XXX
 * @param queue ACL_AQUEUE ṹָ
 * @return 
 */
ACL_API int acl_aqueue_last_error(const ACL_AQUEUE *queue);

/**
 * öΪ˳״̬
 * @param queue ACL_AQUEUE ṹָ
 */
ACL_API void acl_aqueue_set_quit(ACL_AQUEUE *queue);

/**
 * õǰжԪصĸ
 * @param queue {ACL_AQUEUE*}
 * @return {int} Ԫظ< 0 ʾ
 */
ACL_API int acl_aqueue_qlen(ACL_AQUEUE* queue);

#ifdef __cplusplus
}
#endif
#endif

