#ifndef	ACL_IFCONF_INCLUDE_H
#define	ACL_IFCONF_INCLUDE_H

#ifdef	__cplusplus
extern "C" {
#endif

#include "../stdlib/acl_define.h"
#include "../stdlib/acl_argv.h"
#include "acl_sane_inet.h"

typedef struct ACL_IFADDR {
	char name[256];		/* ӿ */
#if defined(_WIN32) || defined(_WIN64)
	char desc[256];		/* ӿ */
#endif
	char addr[128];		/* ַʾIPַ */
	ACL_SOCKADDR saddr;	/*  IPV4 & IPV6 ĵַ */
} ACL_IFADDR;

typedef struct ACL_IFCONF {
	ACL_IFADDR *addrs;	/* ACL_IFADDR  */
	int  length;		/* ACL_IFADDR 鳤 */

	/* for acl_iterator */

	/* ȡͷ */
	const ACL_IFADDR *(*iter_head)(ACL_ITER*, struct ACL_IFCONF*);
	/* ȡһ */
	const ACL_IFADDR *(*iter_next)(ACL_ITER*, struct ACL_IFCONF*);
	/* ȡβ */
	const ACL_IFADDR *(*iter_tail)(ACL_ITER*, struct ACL_IFCONF*);
	/* ȡһ */
	const ACL_IFADDR *(*iter_prev)(ACL_ITER*, struct ACL_IFCONF*);
} ACL_IFCONF;

/**
 * ַӿ
 * @return {ACL_IFCONF*} ֵ NULL ʱ acl_free_ifaddrs ͷ
 */
ACL_API ACL_IFCONF *acl_get_ifaddrs(void);

/**
 * ͷ acl_get_ifaddrs() ص ACL_IFCONF ڴ
 * @param ifconf {ACL_IFCONF*}
 */
ACL_API void acl_free_ifaddrs(ACL_IFCONF *ifconf);

/**
 * ɨ豾 IPƥָģʽ IP ַأĿǰ֧ IPV4
 * @param pattern {const char *} ָƥģʽʽΪxxx.xxx.xxx.xxx 
 *  xxx.xxx.xxx.xxx:port磺192.168.*.*, 192.168.*.8:8010.*.0.*:81
 * @return {ACL_IFCONF *} Ľ pattern ж˿ڣԶ
 *  ˿ÿ IP 棬ضǿգͨ acl_free_ifaddrs
 *  ͷŸö
 */
ACL_API ACL_IFCONF *acl_ifconf_search(const char *pattern);

#ifdef	__cplusplus
}
#endif

#endif
