#pragma once
#include "../acl_cpp_define.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)

namespace acl {

class ACL_CPP_API mysql_conf
{
public:
	/**
	 * 캯
	 * @param dbaddr {const char*} ݿӵַΪ TCP ׽ӿڻ
	 *  UNIX ׽ӿڣΪ TCP ׽ӿʱַʽΪip:port, Ϊ UNIX
	 *  ׽ӿʱַʽ/xxx/xxx/xxx.sock
	 * @param dbname {const char*} ݿ
	 */
	mysql_conf(const char* dbaddr, const char* dbname);

	/**
	 * 캯
	 * @param conf {const mysql_conf&} ڲ¶ͬʱ
	 */
	mysql_conf(const mysql_conf& conf);

	~mysql_conf();

	/**
	 * ݿʱû˺
	 * @param dbuser {const char*} Ϊǿַʱָû˺
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_dbuser(const char* dbuser);

	/**
	 * ݿʱ˺
	 * @param dbpass {const char*} Ϊǿַʱָ˺
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_dbpass(const char* dbpass);

	/**
	 * ݿӳ
	 * @param dblimit {size_t} ӳƣΪ 0 ʱ
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_dblimit(size_t dblimit);

	/**
	 *  mysql ݿһЩ־λ
	 * @param dbflags {unsigned long}
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_dbflags(unsigned long dbflags);

	/**
	 * õ޸ݿʱǷԶύĬΪԶύ
	 * @param on {bool}
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_auto_commit(bool on);

	/**
	 * ݿĳʱʱ
	 * @param timeout {int}
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_conn_timeout(int timeout);

	/**
	 * öȡݿĳʱʱ
	 * @param timeout {int}
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_rw_timeout(int timeout);

	/**
	 * ݿӵַ
	 * @param charset {const char*}
	 * @return {mysql_conf&}
	 */
	mysql_conf& set_charset(const char* charset);

	const char* get_dbaddr() const
	{
		return dbaddr_;
	}

	const char* get_dbname() const
	{
		return dbname_;
	}

	const char* get_dbkey() const
	{
		return dbkey_;
	}

	const char* get_dbuser() const
	{
		return dbuser_;
	}

	const char* get_dbpass() const
	{
		return dbpass_;
	}

	size_t get_dblimit() const
	{
		return dblimit_;
	}

	unsigned long get_dbflags() const
	{
		return dbflags_;
	}

	bool get_auto_commit() const
	{
		return auto_commit_;
	}

	int get_conn_timeout() const
	{
		return conn_timeout_;
	}

	int get_rw_timeout() const
	{
		return rw_timeout_;
	}

	const char* get_charset() const
	{
		return charset_;
	}

private:
	char* dbaddr_;          // ݿַ
	char* dbname_;          // ݿ
	char* dbkey_;           // dbname@dbaddr
	char* dbuser_;          // ݿ˺
	char* dbpass_;          // ݿ˺
	char* charset_;         // ݿʱַ
	size_t dblimit_;        // ݿӳ
	unsigned long dbflags_; // ݿʱı־λ
	bool  auto_commit_;     // ǷԶύ޸ĺ
	int   conn_timeout_;    // ݿĳʱʱ
	int   rw_timeout_;      // ݿͨŵĳʱʱ
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_DB_DISABLE)
