#pragma once
#include "../acl_cpp_define.hpp"
#include <map>
#include <vector>
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"
#include "../stream/socket_stream.hpp"
#include "../hsocket/hsproto.hpp"

#ifndef ACL_CLIENT_ONLY

struct ACL_ARGV;

namespace acl {

class hsrow;
class hstable;

class ACL_CPP_API hsclient : public noncopyable
{
public:
	/**
	 * 캯
	 * @param addr {const char*} handlersocket  Mysql ϵļַ
	 * @param cache_enable {bool} ڲǷл湦
	 * @param retry_enable {bool} ΪԭʱǷҪ
	 *  ʽΪip:port
	 */
	hsclient(const char* addr, bool cache_enable = true, bool retry_enable = true);
	~hsclient();

	/**
	 * ѯֵֶƥĽ
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ open
	 *   flds иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦ캯 flds е
	 *  ֶθ
	 * @param cond {const char*} ƥΪ
	 *  = ; >= ڵ; > ; < С; <= Сڵ
	 * @param nlimit {int} ƣ0 ʾƸ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {const std::verctor<hsrow*>&} ؽ
	 */
	const std::vector<hsrow*>& get(const char* values[], int num,
		const char* cond = "=", int nlimit = 0, int noffset = 0);

	/**
	 * ѯֵֶƥĽ
	 * @param first_value {const char*} ΪӦڹ캯 flds ֶμ
	 *  ĵһֶεֵֶ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {const std::verctor<hsrow*>&} ؽ
	 */
	const std::vector<hsrow*>& get(const char* first_value, ...)
		ACL_CPP_PRINTF(2, 3);

	/**
	 * ݿƥֶεֵ
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ open
	 *   flds иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦ캯 flds е
	 *  ֶθ
	 * @param to_values {cosnt *[]} ƥֵֵֶֶ˳Ӧ open 
	 *  ֶ˳ͬ
	 * @param to_num {int} to_values 鳤
	 * @param cond {const char*} ƥΪ
	 *  = ; >= ڵ; > ; < С; <= Сڵ
	 * @param nlimit {int} ƣ0 ʾƸ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {bool} Ƿɹ
	 */
	bool mod(const char* values[], int num,
		const char* to_values[], int to_num,
		const char* cond = "=", int nlimit = 0, int noffset = 0);

	/**
	 * ɾݿƥֶεļ¼
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ open
	 *   flds иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦ캯 flds е
	 *  ֶθ
	 * @param cond {const char*} ƥΪ
	 *  = ; >= ڵ; > ; < С; <= Сڵ
	 * @param nlimit {int} ɾݵĸ, 0 ʾ
	 * @param noffset {int} ʼλ(0ʾӵһʼ)
	 * @return {bool} Ƿɹ
	 */
	bool del(const char* values[], int num, const char* cond = "=",
		int nlimit = 0, int noffset = 0);

	/**
	 * ɾݿƥֶεļ¼
	 * @param first_value {const char*} ΪӦڹ캯 flds ֶμ
	 *  ĵһֶεֵֶ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {bool} Ӽ¼Ƿɹ
	 */
	bool fmt_del(const char* first_value, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * ݿ¼¼
	 * @param values {const char*[]} ƥֵֶ飬ֵֶļ˳Ӧ빹
	 *   flds иֶε˳ͬ
	 * @param num {int} values 鳤ȣֵӦ캯 flds е
	 *  ֶθ
	 * @return {bool} Ӽ¼Ƿɹ
	 */
	bool add(const char* values[], int num);

	/**
	 * ݿ¼¼
	 * @param first_value {const char*} ΪӦڹ캯 flds ֶμ
	 *  ĵһֶεֵֶ
	 * @param ... {const char*} бһΪ NULL ʾ
	 * @return {bool} Ӽ¼Ƿɹ
	 */
	bool fmt_add(const char* first_value, ...) ACL_CPP_PRINTF(2, 3);

	/**
	 * Ƿе
	 * @param on {bool} true ʾеԣὫһЩмϢ־
	 */
	void debug_enable(bool on);

	/**
	 * ݿ
	 * @param dbn {const char*} ݿ
	 * @param tbl {const char*} ݿ
	 * @param idx {const char*} ֶ
	 * @param flds {const char*} Ҫ򿪵ֶϣʽΪ
	 *  ɷָ ",; \t" ֶָƣ磺user_id,user_name,user_mail
	 * @param auto_open {bool} δǷԶ
	 * @return {bool} true ʾ򿪣ʾ򿪱ʧ
	 */
	bool open_tbl(const char* dbn, const char* tbl,
		const char* idx, const char* flds, bool auto_open = true);

	/**
	 * ӵַ
	 * @return {const char*} Ϊ
	 */
	const char* get_addr() const;

	/**
	 * ó
	 * @return {int}
	 */
	int  get_error() const;

	/**
	 * óϢ
	 * @param errnum {int}  get_error õĴ
	 * @return {const char*}
	 */
	const char* get_serror(int errnum) const;

	/**
	 * ϴγʱĴϢ
	 * @return {const char*}
	 */
	const char* get_last_serror() const;

	/**
	 * õǰ hsclient õ id 
	 * @return {int}
	 */
	int get_id() const;
private:
	bool   debugOn_;
	char*  addr_;
	hsproto  proto_;
	bool   retry_enable_;
	int    id_max_;
	hstable* tbl_curr_;
	string buf_;

	// 
	socket_stream stream_;
	std::map<string, hstable*> tables_;

	char   cond_def_[2];
	int    error_;
	const char* serror_;

	// ݿ
	bool open_tbl(const char* dbn, const char* tbl,
		const char* idx, const char* flds, const char* key);

	// дݿʱҪô˺رͷ
	// 
	void close_stream();

	// ڲ򿪵ݿĶ
	void clear_tables();

	// ݿⷢͲѯȡý
	bool query(const char* oper, const char* values[], int num,
		const char* limit_offset, char mop,
		const char* to_values[], int to_num);
	bool chat();
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
