#pragma once
#include "../acl_cpp_define.hpp"
#include "../stream/aio_socket_stream.hpp"
#if !defined(_WIN32) && !defined(_WIN64)
#include <netinet/in.h>  // just for "struct sockaddr_storage"
#endif

struct HTTP_HDR;
struct HTTP_HDR_RES;
struct HTTP_RES;
struct HTTP_HDR_REQ;
struct HTTP_REQ;

struct ACL_ASTREAM_CTX;

namespace acl {

class string;
class aio_handle;
class aio_socket_stream;
class socket_stream;
class zlib_stream;
class websocket;
class sslbase_conf;
class sslbase_io;
class http_header;

/**
 * HTTP ͻ첽ֱ֧ͨ࣬׼ HTTP ͨЭ飬֧ Websocket ͨţ
 *  HTTP Э鼰 Websocket ͨž֧ SSL ܴ䣻
 * ⣬ HTTP Э飬ûãԶѹ GZIP Ӧݣڻص
 *  on_http_res_body() յıǽѹݡ
 */
class ACL_CPP_API http_aclient : public aio_open_callback
{
public:
	/**
	 * 캯
	 * @param handle {aio_handle&} 첽ͨ¼
	 * @param ssl_conf {sslbase_conf*}  NULL ʱԶ SSL ͨŷʽ
	 */
	http_aclient(aio_handle& handle, sslbase_conf* ssl_conf = NULL);
	virtual ~http_aclient(void);

	/**
	 * ʱĻصʵ
	 */
	virtual void destroy(void) = 0;

	/**
	 *  HTTP ͷԱӦ HTTP ͷеֶ
	 * @return {http_header&}
	 */
	http_header& request_header(void);

	/**
	 *  HTTP ЭӦǷԶнѹ
	 * @param on {bool}
	 * @return {http_aclient&}
	 */
	http_aclient& unzip_body(bool on);

	/**
	 * Ƿ GZIP ѹԶнѹ
	 * @return {bool}
	 */
	bool is_unzip_body(void) const
	{
		return unzip_;
	}

	/**
	 * ڹ캯 SSL conf ⣬ͨ˷ã
	 * 캯õ ssl_conf Ϊ NULLڲԶ ssl_enable_ Ϊ
	 * falseͨ ssl_conf  enable_ssl()
	 *  ssl 
	 * @param ssl_conf {sslbase_conf*} Ϊ NULL ʱȡ SSL
	 * @return {http_aclient&}
	 */
	http_aclient& set_ssl_conf(sslbase_conf* ssl_conf);

	/**
	 * õ SSL 
	 * @return {sslbase_conf*} Ϊ NULL ʾδ
	 */
	sslbase_conf* get_ssl_conf(void) const
	{
		return ssl_conf_;
	}

	/**
	 * 캯 ssl_conf ǿʱԵô˷Ƿ SSL
	 * ܣ ssl_conf ǿգڲ ssl_enable_ ȱʡֵΪ trueͨ
	 * رջ ssl 
	 * @param yes {bool}
	 * @return {http_aclient&}
	 */
	http_aclient& enable_ssl(bool yes);

	/**
	 * жڲǷ ssl 
	 * @return {bool}
	 */
	bool is_enable_ssl(void) const
	{
		return ssl_enable_ && ssl_conf_;
	}

	/**
	 * ʼ첽Զ WEB 
	 * @param addr {const char*} Զ WEB ַʽΪ
	 *  domain:port  ip:port, ַΪʱڲԶ첽
	 *  ̣Ҫڳʼʱͨ aio_handle::set_dns() ù
	 *  ַַΪ IP Ҫַ
	 * @param conn_timeout {int} ӳʱʱ䣨룩
	 * @param rw_timeout {int}  IO дʱʱ䣨룩
	 * @return {bool}  false ʾʧܣ true ʾ첽
	 */
	bool open(const char* addr, int conn_timeout, int rw_timeout);

	/**
	 * 첽ر
	 */
	void close(void);

	/**
	 * ñӣ۳ɹʧܣʹõ DNS ַ
	 * @param out {string&} 洢
	 * @return {bool}  false ʾûпõ DNS ַ
	 */
	bool get_ns_addr(string& out);

	/**
	 * ӳɹʧܻӳʱʱɵô˷õǰõӦ÷ַ
	 * @param out {string&} 洢
	 * @return {bool}  false ʾûӷĵַ
	 */
	bool get_server_addr(string& out);

	/**
	 * ӳɹɵñ첽Ӷ
	 * @return {aio_socket_stream*}
	 */
	aio_socket_stream* get_conn(void) const
	{
		return conn_;
	}

protected:
	/**
	 * ӳɹĻصʵ֣Ӧڸ÷ﹹ HTTP 
	 *  send_request  WEB  HTTP 
	 * @return {bool} ÷ false ڲԶر
	 */
	virtual bool on_connect(void) = 0;

	/**
	 * ʧʱĻصڵñڲԶ this->destroy() 
	 */
	virtual void on_ns_failed(void) {}

	/**
	 * ӳʱĻصڵñڲԶ this->destroy() 
	 */
	virtual void on_connect_timeout(void) {}

	/**
	 * ʧܺĻصڵñڲԶ this->destroy() 
	 */
	virtual void on_connect_failed(void) {}

	/**
	 * ʱʱĻص
	 * @return {bool} ʱص trueڲݣ
	 *   falseӽᱻرգŻص on_disconnect() 鷽
	 */
	virtual bool on_read_timeout(void) { return false; }

	/**
	 * ӳɹӹرպĻصڲô˷ص
	 * destroy() 
	 */
	virtual void on_disconnect(void) {};

	/**
	 * յ WEB ˵ӦͷʱĻص
	 * @param header {const http_header&}
	 * @return {bool}  false 򽫻رӣ
	 */
	virtual bool on_http_res_hdr(const http_header& header)
	{
		(void) header;
		return true;
	}

	/**
	 * յ WEB ˵ӦʱĻص÷ܻᱻλص
	 * ֱӦݶ
	 * @param data {char*} Ĳ
	 * @param dlen {size_t} ζ data ݵĳ
	 * @return {bool}  false 򽫻رӣ
	 */
	virtual bool on_http_res_body(char* data, size_t dlen)
	{
		(void) data;
		(void) dlen;
		return true;
	}

	/**
	 *  HTTP ӦĻص
	 * @param success {bool} Ƿɹ HTTP Ӧ
	 * @return {bool} ɹ󷵻 false ر
	 */
	virtual bool on_http_res_finish(bool success)
	{
		(void) success;
		return true;
	}

	/**
	 *  websocket ֳɹĻص
	 * @return {bool}  false ʾҪرӣ
	 */
	virtual bool on_ws_handshake(void)
	{
		// ʼ첽 websocket 
		this->ws_read_wait(0);
		return true;
	}

	/**
	 *  websocket ʧܺĻص
	 * @param status {int} ص HTTP Ӧ״̬
	 */
	virtual void on_ws_handshake_failed(int status) { (void) status; }

	/**
	 * һ text ͵֡ʱĻص
	 * @return {bool}  true ʾҪر
	 */
	virtual bool on_ws_frame_text(void) { return true; }

	/**
	 * һ binary ͵֡ʱĻص
	 * @return {bool}  true ʾҪر
	 */
	virtual bool on_ws_frame_binary(void) { return true; }

	/**
	 * һر֡ʱĻص
	 */
	virtual void on_ws_frame_closed(void) {}

	/**
	 *  websocket ͨŷʽʱĻص
	 * @param data {char*} ݵַ
	 * @param dlen {size_t} ݳ
	 * @return {bool}  true ʾҪر
	 */
	virtual bool on_ws_frame_data(char* data, size_t dlen)
	{
		(void) data;
		(void) dlen;
		return true;
	}

	/**
	 * һ֡ʱĻص
	 * @return {bool}  true ʾҪر
	 */
	virtual bool on_ws_frame_finish(void) { return true; }

	/**
	 * յ ping ݰʱĻصûصغûûн
	 * data ڲԶԶд pong Ϣû data 
	 * ÷غ󲻻Խӷ pong Ϣ
	 * @param data {string&} 
	 */
	virtual void on_ws_frame_ping(string& data)
	{
		(void) data;
	}

	/**
	 * յ pong ʱĻص
	 * @param data {string&} 
	 */
	virtual void on_ws_frame_pong(string& data)
	{
		(void) data;
	}

public:
	/**
	 *  WEB  HTTP ڲڷͺԶʼ HTTP Ӧ
	 * @param body {const void*} HTTP 壬Ϊ NULL ʱڲ
	 *   HTTP GET 
	 * @param len {size_t} body  NULL ʱʾĳ
	 */
	void send_request(const void* body, size_t len);

	/**
	 *  WEBSOCKET 
	 * @param key {const void*} õ key ֵ
	 * @param len {size_t} key ֵĳ
	 */
	void ws_handshake(const void* key, size_t len);
	void ws_handshake(const char* key = "123456789xxx");

	/**
	 *  ws_handshake() ʱڲ websocket صͷϢ
	 * ͬʱͨ˻ص֮շ websocket ͷϢ
	 */
	virtual void ws_handshake_before(http_header& reqhdr)
	{
		(void) reqhdr;
	}

	/**
	 * ʼ첽 websocket 
	 * @param timeout {int} ʱʱ䣬ֵ <= 0ʱʱ䣬
	 *  򵱶ʱʱʱصᱻã
	 *  ע⣺
	 *  ֵ open() е rw_timeout ͬopen() еĶʱ
	 *  ׼ HTTP IO ̼ SSL ̵ֹĶʱ˴Ķʱ
	 *   websocket صĶʱҪǿǵ websocket Ӧúܶ
	 *  ǳӳ
	 */
	void ws_read_wait(int timeout = 0);

	/**
	 * 첽һ FRAME_TEXT ͵֡
	 * @param data {char*} ڲԭ򱻸ı
	 * @param len {size_t} data ݳ
	 * @return {bool}
	 */
	bool ws_send_text(char* data, size_t len);

	/**
	 * 첽һ FRAME_BINARY ͵֡
	 * @param data {void*} ڲԭ򱻸ı
	 * @param len {size_t} data ݳ
	 * @return {bool}
	 */
	bool ws_send_binary(void* data, size_t len);

	/**
	 * 첽һ FRAME_PING ͵֡
	 * @param data {void*} ڲԭ򱻸ı
	 * @param len {size_t} data ݳ
	 * @return {bool}
	 */
	bool ws_send_ping(void* data, size_t len);

	/**
	 * 첽һ FRAME_PONG ͵֡
	 * @param data {void*} ڲԭ򱻸ı
	 * @param len {size_t} data ݳ
	 * @return {bool}
	 */
	bool ws_send_pong(void* data, size_t len);

protected:
	// @override dummy
	bool open_callback(void) { return true; }

	// @override
	bool timeout_callback(void);

	// @override
	void close_callback(void);

	// @override
	bool read_wakeup(void);

	// @override
	bool read_callback(char* data, int len);

protected:
	unsigned           status_;
	int                rw_timeout_;
	int                gzip_header_left_;	// gzip ʱѹͷ
	bool               keep_alive_;
	bool               unzip_;		// ǷԶѹӦ
	aio_handle&        handle_;
	sslbase_conf*      ssl_conf_;		// ǿʱ SSL 
	bool               ssl_enable_;		// Ƿ SSL 
	aio_socket_stream* conn_;
	socket_stream*     stream_;
	http_header*       header_;
	HTTP_HDR_RES*      hdr_res_;
	HTTP_RES*          http_res_;
	websocket*         ws_in_;
	websocket*         ws_out_;
	string*            buff_;
	zlib_stream*       zstream_;		// ѹ
	struct sockaddr_storage ns_addr_;	// ʹõ DNS ַ
	struct sockaddr_storage serv_addr_;	// ӵӦ÷ַ

	bool handle_connect(const ACL_ASTREAM_CTX* ctx);
	bool handle_ssl_handshake(void);

	bool handle_res_hdr(int status);

	bool handle_res_body(char* data, int dlen);
	bool res_plain(char* data, int dlen);
	bool res_unzip(zlib_stream& zstream, char* data, int dlen);

	bool handle_res_body_finish(char* data, int dlen);
	bool res_plain_finish(char* data, int dlen);
	bool res_unzip_finish(zlib_stream& zstream, char* data, int dlen);

	bool handle_websocket(void);
	bool handle_ws_data(void);
	bool handle_ws_ping(void);
	bool handle_ws_pong(void);
	bool handle_ws_other(void);

private:
	static int connect_callback(const ACL_ASTREAM_CTX* ctx);
	static int http_res_hdr_cllback(int status, void* ctx);
	static int http_res_callback(int status, char* data, int dlen, void* ctx);
};

} // namespace acl
