#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"

namespace acl {

class http_client;
class http_request;
class http_header;

class ACL_CPP_API http_download : public noncopyable
{
public:
	/**
	 * 캯
	 * @param url {const char*} ļڷϵ url ַ
	 * @param addr {const char*} ǿʱ÷ַ(ʽΪ:
	 *  ip[|domain]:portַ url ȡ
	 */
	http_download(const char* url, const char* addr = NULL);
	virtual ~http_download();

	/**
	 * ڵ run ֮ǰͨͷ󣬱û
	 * Լͷֶ( set_method/set_range ڲԶõ)
	 * @return {http_header*}  NULL ʾ URL Ƿ
	 */
	http_header* request_header() const;

	/**
	 * ô˺Ի http_request 󣬱ûѯͷ
	 * 򷵻еĲ
	 * @return {http_request*}  NULL ʾ URL Ƿ
	 */
	http_request* request() const;

	/**
	 * ļ range_from >= 0  range_to >= range_from ʱԶ
	 * ÷ֶطʽȫطʽ
	 * @param range_from {acl_int64} ʼƫλã± 0 ʼ
	 *  ֵ >= 0  range_to >= ֵʱŲ÷ֶطʽ
	 * @param range_to {acl_int64} ؽƫλ
	 * @param req_body {const char*} 
	 * @param len {size_t} req_body ǿʱָ䳤
	 * @return {bool} Ƿɹ true ʾسɹ
	 *  Ƿ URL ڣֶ֧ϵ㴫䣬
	 *  ع෵ false ֹ
	 */
#if defined(_WIN32) || defined(_WIN64)
	bool get(__int64 range_from = -1, __int64 range_to = -1,
		const char* req_body = NULL, size_t len = 0);
#else
	bool get(long long int range_from = -1, long long int range_to = -1,
		const char* req_body = NULL, size_t len = 0);
#endif

	/**
	 * ڲ״̬
	 * @param url {const char*} ǿʱô URL 캯 URL,
	 *  Ȼʹù캯ʹõ url
	 * @param addr {const char*} ǿʱ÷ַ(ʽΪ:
	 *  ip[|domain]:portַ url ȡ
	 * @return {bool}  false ʾ url Ƿ
	 */
	bool reset(const char* url = NULL, const char* addr = NULL);

	/**
	 * ȡɹ캯 reset  url
	 * @return {const char*}  NULL ʾ url Ƿ
	 */
	const char* get_url() const;

	/**
	 * ȡɹ캯 reset  url õķַʽΪ
	 * ip[|domain]:port
	 * @return {const char*}  NULL ʾ url Ƿ
	 */
	const char* get_addr() const;

protected:
	/**
	 *  HTTP ݺ󣬶 HTTP ӦͷĻص
	 * @param conn {http_client*}
	 * @return {bool} ෵ false ֹͣ
	 */
	virtual bool on_response(http_client* conn);

	/**
	 * õļȺĻص
	 * @param n {__int64} ļ
	 * @return {bool} ෵ false ֹͣ
	 */
#if defined(_WIN32) || defined(_WIN64)
	virtual bool on_length(__int64 n);
#else
	virtual bool on_length(long long int n);
#endif

	/**
	 * عУر֪ͨصݼݳ
	 * @param data {const void*} صݵַ
	 * @param len {size_t} صݳ
	 * @return {bool} ෵ false ֹͣ
	 */
	virtual bool on_save(const void* data, size_t len) = 0;

private:
	char* url_;
	char  addr_[128];
	http_request* req_;

	// ͷʼļ
	bool save_total(const char* body, size_t len);

	// ϵزļ
#if defined(_WIN32) || defined(_WIN64)
	bool save_range(const char* body, size_t len,
		__int64 range_from, __int64 range_to);
#else
	bool save_range(const char* body, size_t len,
		long long int range_from, long long int range_to);
#endif

	// ʼ
	bool save(http_request* req);
};

} // namespace acl
