#pragma once
#include "../acl_cpp_define.hpp"
#include <vector>
#include <list>
#include "../stdlib/dbuf_pool.hpp"
#include "../stdlib/string.hpp"
#include "../mime/mime_attach.hpp"
#include "http_type.hpp"

#if !defined(ACL_MIME_DISABLE)

struct MIME_STATE;
struct MIME_NODE;

namespace acl {

/**
 * http mime ̳࣬йϵ
 *   http_mime_node : mime_attach : mime_node
 * úܣ
 * http_mime_node::get_mime_type øý
 * mime_node::get_name: øý
 * mime_attach::get_filename: Ϊϴļʱ˺
 *   ϴļļ
 * http_mime_node::get_value: Ϊʱ˺
 *   ֵ
 */
class ACL_CPP_API http_mime_node : public mime_attach
{
public:
	/**
	 * @param path {const char*} ԭʼļ·Ϊ
	 * @param node {MIME_NODE*} Ӧ MIME 㣬ǿ
	 * @param decodeIt {bool} Ƿ MIME ͷ
	 *  ݽн
	 * @param toCharset {const char*} ַ
	 * @param off {off_t} ƫλ
	 */
	http_mime_node(const char* path, const MIME_NODE* node,
		bool decodeIt = true, const char* toCharset = "gb2312",
		off_t off = 0);
	~http_mime_node(void);

	/**
	 * øý
	 * @return {http_mime_t}
	 */
	http_mime_t get_mime_type(void) const;

	/**
	 *  get_mime_type صΪ HTTP_MIME_PARAM ʱ
	 * ô˺òֵͨ get_name() 
	 * @return {const char*}  NULL ʾ
	 */
	const char* get_value(void) const;

protected:

private:
	http_mime_t mime_type_;
	char* param_value_;

	void load_param(const char* path);
};

//////////////////////////////////////////////////////////////////////////

/**
 * http mime ýΪʽûʹʱÿν
 * ݸ update ú true ʱʾҽȷ
 */
class ACL_CPP_API http_mime : public dbuf_obj
{
public:
	/**
	 * 
	 * @param boundary {const char*} ָΪ
	 * @param local_charset {const char*} ַǿʱԶ
	 *  תΪַ
	 */
	http_mime(const char* boundary, const char* local_charset  = "gb2312");
	~http_mime(void);

	/**
	 *  MIME ݵĴ洢· MIME ݺҪ
	 * ȡݣ MIME ԭʼݵĴ洢λã
	 * ޷Ӧݣ save_xxx/get_nodes/get_node ޷
	 * ʹ
	 * @param path {const char*} ļ·, òΪ, 
	 *  , Ҳܵ save_xxx صĽӿ
	 */
	void set_saved_path(const char* path);

	/**
	 * ô˺ʽʽ
	 * @param data {const char*} (ͷҲ, 
	 *  Ҳ)
	 * @param len {size_t} data ݳ
	 * @return {bool}  multipart ,  true ʾ;
	 *  ڷ multipart ļ, ÷ֵԶΪ false, ûκ, 
	 *  ҪԼжĽλ
	 * ע: ˺һҪ update_end ֪ͨ
	 * 
	 */
	bool update(const char* data, size_t len);

	/**
	 * е MIME 
	 * @return {const std::list<http_mimde_node*>&}
	 */
	const std::list<http_mime_node*>& get_nodes(void) const;

	/**
	 * ݱȡ HTTP MIME 
	 * @param name {const char*} 
	 * @return {const http_mime_node*} ؿ˵ӦĽ
	 *  
	 */
	const http_mime_node* get_node(const char* name) const;

private:
	string boundary_;
	string save_path_;
	off_t off_;
	MIME_STATE* mime_state_;
	std::list<http_mime_node*> mime_nodes_;
	char  local_charset_[32];
	bool  decode_on_;
	bool  parsed_;
};

} // namespace acl

#endif // !defined(ACL_MIME_DISABLE)
