#pragma once
#include "../acl_cpp_define.hpp"
#include "ipc_service.hpp"
#if defined(_WIN32) || defined(_WIN64)
 struct acl_pthread_mutex_t;
 struct acl_pthread_cond_t;
#else
# include <pthread.h>
# ifndef	acl_pthread_mutex_t
#  define	acl_pthread_mutex_t	pthread_mutex_t
# endif
# ifndef	acl_pthread_cond_t
#  define	acl_pthread_cond_t	pthread_cond_t
# endif
#endif

namespace acl {

class ipc_client;
class rpc_client;
class rpc_service;

class rpc_request;
struct RPC_DAT
{
	rpc_request* req;
	void* ctx;
};

class ACL_CPP_API rpc_request : public ipc_request
{
public:
	rpc_request(void);
	virtual ~rpc_request(void);

protected:
	friend class rpc_client;
	friend class rpc_service;

	/**
	 * ߳бãʵִ˽ӿڣ
	 * ̴߳ýӿڽãԸֻ
	 * ǵӿڵúܱͷţֹڵñӿǰͷű
	 */
	virtual void rpc_onover(void) = 0;

	/**
	 * ӿڣ̵߳ñ rpc_signal ʱ߳л
	 * ñӿڣ֪ͨδǰ( rpc_onover ǰ)յ
	 * ߳ем״̬ϢڲԶ֧׽ӿڻ _WIN32 
	 * ϢӦó磬 HTTP Ӧã߳п
	 * һأһ̷߳( rpc_signal )ؽ̣
	 * ̻߳ñʵĴ˷Ϣ
	 */
	virtual void rpc_wakeup(void* ctx) { (void) ctx; }

protected:
	/**
	 * ߳бãʵִ˽ӿڣڴ
	 */
	virtual void rpc_run(void) = 0;

	/**
	 * ߳бãڲԶ֧׽ӿڻ _WIN32 Ϣ
	 * ʵ rpc_run пԶεô˷̵߳
	 * ʵϢ߳еñ rpc_wakeup 
	 * @param ctx {void*} ݵĲָ룬һӦǶַ̬
	 *  ȽϺãԱͬһظǵ
	 */
	void rpc_signal(void* ctx);

	/**
	 * ̵߳ rpc_signal ̺߳󣬵ñԵȴ
	 * ̷߳һָ
	 * @param timeout {int} ȴʱʱ()ֵΪ 0 ʱ
	 *  ÷ȴģʽֵΪ < 0 ʱȫ
	 *  ȴģʽ(һֱȵ̷߳ cond_signal ֪ͨ)
	 *  ֵ > 0 ʱȴʱʱΪ timeout 
	 * @return {bool}  true ʾյ̷֪߳ͨźţ
	 *  Ҫ cond_wait_timeout жǷǳʱ
	 */
	bool cond_wait(int timeout = -1);

	/**
	 *  cond_wait  false ʱӦӦõñжǷ
	 * Ϊȴʱ
	 * @return {bool} Ƿǵȴʱ
	 */
	bool cond_wait_timeout() const
	{
		return wait_timedout_;
	}

	/**
	 * ̵߳ cond_wait ʱ߳еñ֪ͨ߳
	 * 
	 * @return {bool} ̵߳ cond_wait ʱ֪ͨ߳
	 *  ҷ true򷵻 false
	 */
	bool cond_signal(void);

private:
	RPC_DAT dat_;
	ipc_client* ipc_;
	int   cond_count_;
	acl_pthread_mutex_t* lock_;
	acl_pthread_cond_t* cond_;
	bool wait_timedout_;

	//  ipc_request 麯߳б
	virtual void run(ipc_client* ipc);
#if defined(_WIN32) || defined(_WIN64)
	/**
	 * ӿڣʵִڴ񣬸ýӿ
	 * ڲ _WIN32 Ϣģʽ
	 * @param hWnd {HWND} WIN2 ھ
	 */
	virtual void run(HWND hWnd);
#endif
};

//////////////////////////////////////////////////////////////////////////

class aio_socket_stream;

class ACL_CPP_API rpc_service : public ipc_service
{
public:
	/**
	 * 캯
	 * @param nthread {int} ֵ > 1 ڲԶ̳߳أ
	 *  һһ߳
	 * @param ipc_keep {bool} ڲ IPC ϢǷ񱣳ֳӣֳ
	 *  ϢݵЧ
	 */
	rpc_service(int nthread, bool ipc_keep = true);

	~rpc_service(void) {}

	/**
	 * ߳У̳߳صУ̳߳
	 * еһ߳̽յ rpc_request::rpc_run 
	 * ķϺ̷߳Ϣ߳ٵ
	 * rpc_request::rpc_callback
	 * @param req {rpc_request*} rpc_request ʵǿ
	 */
	void rpc_fork(rpc_request* req);

private:
	// 麯̶߳յ߳Ϣ
	// ipc ʱĻص
	virtual void on_accept(aio_socket_stream* client);

#if defined(_WIN32) || defined(_WIN64)
	/**
	 * 麯յ̵߳ win32 ϢʱĻص
	 * @param hWnd {HWND} ھ
	 * @param msg {UINT} ûԶϢ
	 * @param wParam {WPARAM} 
	 * @param lParam {LPARAM} 
	 */
	virtual void win32_proc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
#endif
};

} // namespace acl
