#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"
#include "master_conf.hpp"
#include <vector>

#ifndef ACL_CLIENT_ONLY

struct ACL_EVENT;

namespace acl
{

class server_socket;
class event_timer;
class string;

class ACL_CPP_API master_base : public noncopyable
{
public:
	/**
	 *  bool ͵
	 * @param table {master_bool_tbl*}
	 * @return {master_base&}
	 */
	master_base& set_cfg_bool(master_bool_tbl* table);

	/**
	 *  int ͵
	 * @param table {master_int_tbl*}
	 * @return {master_base&}
	 */
	master_base& set_cfg_int(master_int_tbl* table);

	/**
	 *  int64 ͵
	 * @param table {master_int64_tbl*}
	 * @return {master_base&}
	 */
	master_base& set_cfg_int64(master_int64_tbl* table);

	/**
	 *  ַ ͵
	 * @param table {master_str_tbl*}
	 * @return {master_base&}
	 */
	master_base& set_cfg_str(master_str_tbl* table);

	/**
	 * жǷ acl_master Ƶ daemon ģʽ
	 * @return {bool}
	 */
	bool daemon_mode(void) const;

	/////////////////////////////////////////////////////////////////////
	
	/**
	 * ý̼Ķʱú̵ֻ߳пռ (ں
	 * proc_on_init) бãöʱִϺԶ
	 * (ڲԶ master_timer::destroy )
	 * @param timer {event_timer*} ʱ
	 * @return {bool} öʱǷɹ
	 */
	bool proc_set_timer(event_timer* timer);

	/**
	 * ɾ̼ʱ
	 * @param timer {event_timer*}  proc_set_timer õĶʱ
	 */
	void proc_del_timer(event_timer* timer);

protected:
	bool daemon_mode_;
	bool proc_inited_;
	std::vector<server_socket*> servers_;

	master_base();
	virtual ~master_base();

	/**
	 * ڽʱÿɹһصַñ
	 * @param ss {const server_socket&} 
	 */
	virtual void proc_on_listen(server_socket& ss) { (void) ss; }

	/**
	 * лûǰõĻصڴ˺һЩ
	 * ûΪ root Ȩ޲
	 */
	virtual void proc_pre_jail() {}

	/**
	 * лûݺõĻص˺ʱ
	 * ȨΪͨ޼
	 */
	virtual void proc_on_init() {}

	/**
	 * ˳ǰõĻص
	 */
	virtual void proc_on_exit() {}

	/**
	 * յ SIGHUP źʱĻص鷽
	 */
	virtual bool proc_on_sighup(string&) { return true; }

	// ö
	master_conf conf_;

protected:
	// ñ¼
	void set_event(ACL_EVENT* event);

	/**
	 * ¼湻
	 * @return {ACL_EVENT*}
	 */
	ACL_EVENT* get_event(void) const
	{
		return event_;
	}

private:
	ACL_EVENT* event_;
};

}  // namespace acl

#endif // ACL_CLIENT_ONLY

