#pragma once
#include "master_base.hpp"

#ifndef ACL_CLIENT_ONLY

struct ACL_VSTREAM;
struct ACL_EVENT;
struct ACL_VSTRING;

namespace acl {

class socket_stream;

/**
 * acl_master н̷ʽģֻ࣬һʵ
 */
class ACL_CPP_API master_proc : public master_base
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param count {int} ֵ > 0 ʱյӴﵽֵ
	 *  󣬸úأһֱѭԶ
	 * @return {bool} Ƿɹ
	 */
	bool run_alone(const char* addrs, const char* path = NULL, int count = 1);

	/**
	 * ļ·
	 * @return {const char*} ֵΪ NULL ʾûļ
	 */
	const char* get_conf_path(void) const;

protected:
	master_proc();
	virtual ~master_proc();

	/**
	 * 麯յһͻʱô˺
	 * @param stream {aio_socket_stream*} ½յĿͻ첽
	 * עúغӽᱻرգûӦرո
	 */
	virtual void on_accept(socket_stream* stream) = 0;

private:
	// յһͻʱص˺
	static void service_main(void*, ACL_VSTREAM *stream);

	// һַʱص˺
	static void service_on_listen(void*, ACL_VSTREAM*);

	// лûݺõĻص
	static void service_pre_jail(void*);

	// лûݺõĻص
	static void service_init(void*);

	// ˳ʱõĻص
	static void service_exit(void*);

	// յ SIGHUP źźص
	static int service_on_sighup(void*, ACL_VSTRING*);

private:
	// ڵзʽ£ú׽ӵʱ
	static void listen_callback(int event_type, ACL_EVENT*,
		ACL_VSTREAM*, void* context);

private:
	bool stop_;
	int  count_limit_;
	int  count_;
};

}  // namespace acl

#endif // ACL_CLIENT_ONLY
