#pragma once
#include "../acl_cpp_define.hpp"
#include "master_base.hpp"
#include "../stdlib/thread_mutex.hpp"

#ifndef ACL_CLIENT_ONLY

struct ACL_VSTRING;

namespace acl {

class ACL_CPP_API master_udp : public master_base
{
public:
	/**
	 * ʼУøúָ÷ acl_master 
	 * ֮Уһ״̬
	 * @param argc {int}  main дݵĵһʾ
	 * @param argv {char**}  main дݵĵڶ
	 */
	void run_daemon(int argc, char** argv);

	/**
	 * ڵʱĴûԵô˺һЩҪĵԹ
	 * @param addrs {const char*} ַбʽIP:PORT, IP:PORT...
	 * @param path {const char*} ļȫ·
	 * @param count {unsigned int} ѭĴﵽֵԶأ
	 *  ֵΪ 0 ʾһֱѭ
	 * @return {bool} Ƿɹ
	 */
	bool run_alone(const char* addrs, const char* path = NULL,
		unsigned int count = 1);

protected:
	// ಻ֱӱʵ
	master_udp();
	virtual ~master_udp();

	/**
	 * 麯 UDP ݿɶʱص˺÷߳е
	 * @param stream {socket_stream*}
	 */
	virtual void on_read(socket_stream* stream) = 0;

	/**
	 *  UDP ַɹص鷽÷߳б
	 */
	virtual void proc_on_bind(socket_stream&) {}

	/**
	 *  UDP ַʱص鷽÷߳б
	 */
	virtual void proc_on_unbind(socket_stream&) {}

	/**
	 * ̳߳ʼʱ鷽
	 */
	virtual void thread_on_init(void) {}

	/**
	 * ñؼ׽ӿ󼯺
	 * @return {const std::vector<socket_stream*>&}
	 */
	const std::vector<socket_stream*>& get_sstreams() const
	{
		return sstreams_;
	}

	/**
	 * ļ·
	 * @return {const char*} ֵΪ NULL ʾûļ
	 */
	const char* get_conf_path(void) const;

public:
	void lock(void);
	void unlock(void);

private:
	std::vector<socket_stream*> sstreams_;
	thread_mutex lock_;

	void run(int argc, char** argv);
	void push_back(socket_stream* ss);
	void remove(socket_stream* ss);

private:
	// յһͻʱص˺
	static void service_main(void*, ACL_VSTREAM*);

	// 󶨵ַɹĻص
	static void service_on_bind(void*, ACL_VSTREAM*);

	// ַʱĻص
	static void service_on_unbind(void*, ACL_VSTREAM*);

	// лûݺõĻص
	static void service_pre_jail(void*);

	// лûݺõĻص
	static void service_init(void*);

	// ˳ʱõĻص
	static void service_exit(void*);

	// ߳ʱõĻص
	static void thread_init(void*);

	// յ SIGHUP źźص
	static int service_on_sighup(void*, ACL_VSTRING*);
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
