#pragma once
#include <time.h>
#include "../stdlib/string.hpp"
#include "../stdlib/locker.hpp"
#include "../stdlib/noncopyable.hpp"
#include "queue_manager.hpp"

#ifndef MAXPATH255
#define MAXPATH255 255
#endif

namespace acl {

class fstream;

class ACL_CPP_API queue_file : public noncopyable
{
public:
	queue_file();

	/**
	 * ļָ
	 * @return {acl::fstream*} ļָ, Ϊ NULL ˵ļδ
	 */
	fstream* get_fstream(void) const;

	/**
	 * ļʱ
	 * @return {time_t},  1970 , ֵΪ (time_t) -1,
	 *  ʾ
	 */
	time_t get_ctime(void) const;

	/**
	 * ļд
	 * @param data {const void*} ݵַ
	 * @param len {size} ݳ
	 * @return {bool} дǷɹ
	 */
	bool write(const void* data, size_t len);
	int format(const char* fmt, ...) ACL_CPP_PRINTF(2, 3);
	int vformat(const char* fmt, va_list ap);

	/**
	 * ļжȡ
	 * @param buf {void*} ַ
	 * @param len {size_t} buf С
	 * @return {int} ȡݳ, -1: ʾʧܻ,
	 *  Ӧùرոļ, > 0: ʾɹ
	 */
	int read(void* buf, size_t len);

	/**
	 * ȡñļļֵ, ֵǶļĲļ(·,
	 * չ)
	 * @return {const char*} ļֵ
	 */
	const char* key(void) const
	{
		return m_partName;
	}

	/**
	 * öļķȫ·
	 * @return {const char*}
	 */
	const char* get_filePath(void) const
	{
		return m_filePath.c_str();
	}

	/**
	 * öļĸ·(Ŀ¼)
	 * @return {const char*}
	 */
	const char* get_home(void) const
	{
		return m_home;
	}

	/**
	 * øöļĶ
	 * @return {const char*} 
	 */
	const char* get_queueName(void) const
	{
		return m_queueName;
	}

	/**
	 * öĿ¼
	 * @return {const char*} Ŀ¼
	 */
	const char* get_queueSub(void) const
	{
		return m_queueSub;
	}

	/**
	 * øöļչ
	 * @return {const char*} չ
	 */
	const char* get_extName(void) const
	{
		return m_extName;
	}

	/**
	 * ѾдݴСߴ
	 * @return {size_t}
	 */
	size_t get_fileSize() const
	{
		return nwriten_;
	}

private:
	friend class queue_manager;

	~queue_file();

	/**
	 * µĶļ, ϺԶļļ
	 * ֱӵøļ lock()/unlock()
	 * @param home {const char*} ļڸ·
	 * @param queueName {const char*} 
	 * @param extName {const char*} ļչ
	 * @param width {unsigned} жĿ¼ĸ
	 * @return {bool} ¶ļǷɹ,  false ˵
	 *   path  extName Ƿ
	 */
	bool create(const char* home, const char* queueName,
		const char* extName, unsigned width);

	/**
	 * ѾڵĶļ, 򿪺Զļļ,
	 * ֱӵøļ lock()/unlock()
	 * @param filePath {const char*} ļ·
	 * @return {bool} 򿪶ļǷɹ
	 */
	bool open(const char* filePath);
	bool open(const char* home, const char* queueName, const char* queueSub,
		const char* partName, const char* extName);

	/**
	 * رյǰļ
	 */
	void close();

	/**
	 * Ӵɾļ
	 * @return {bool} ɾǷɹ
	 */
	bool remove();

	/**
	 * ļӵǰĿ
	 * @param queueName {const char*} Ŀ
	 * @param extName {const char*} Ŀչ
	 * @return {bool} ƶļǷɹ
	 */
	bool move_file(const char* queueName, const char* extName);

	/**
	 * ö
	 * @param queueName {const char*} 
	 */
	void set_queueName(const char* queueName);

	/**
	 * öļչ
	 */
	void set_extName(const char* extName);

	/**
	 * Եǰļ(ļ)
	 * @return {bool} Ƿɹ
	 */
	bool lock(void);

	/**
	 * Եǰļ(ļ)
	 * @return {bool} Ƿɹ
	 */
	bool unlock(void);

private:
	// ļ
	fstream* m_fp;

	// ļڶиĿ¼ȫ·
	string m_filePath;

	// ļĸ·
	char  m_home[MAXPATH255];

	// 
	char  m_queueName[32];

	// µĿ¼
	char  m_queueSub[32];

	// ļ, ·, Ҳļչ
	char  m_partName[MAXPATH255];

	// ļչ
	char  m_extName[32];

	// 
	locker m_locker;

	// ǰļǷѾ
	bool  m_bLocked;

	// ļǷѾ
	bool  m_bLockerOpened;

	// ѾдļߴС
	size_t nwriten_;
};

} // namespace acl
