#pragma once
#include "../acl_cpp_define.hpp"
#include <vector>
#include <map>
#include "../stdlib/string.hpp"
#include "../connpool/connect_manager.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_REDIS_DISABLE)

namespace acl
{

class sslbase_conf;

class redis_client_pool;

/**
 * redis ͻ˼Ⱥ࣬ͨע redis ͻ(redis_command)
 * ʹеĿͻԶּ֧Ⱥ redis 
 * redis client cluster class. The class's object is set in the redis_command
 * using redis_command::set_cluster(redis_cluster*), and all the redis client
 * command will support the redis cluster mode.
 */
class ACL_CPP_API redis_client_cluster : public connect_manager
{
public:
	/**
	 * 캯;
	 * constructor
	 * @param max_slot {int} ϣֵ; the max hash-slot value of keys
	 */
	redis_client_cluster(int max_slot = 16384);
	virtual ~redis_client_cluster(void);

	/**
	 * ݹϣֵöӦӳ;
	 * get one connection pool with the given slot
	 * @param slot {int} ϣֵ;
	 *  the hash-slot value of key
	 * @return {redis_client_pool*} ӦĹϣ۲򷵻 NULL;
	 *  return the connection pool of the hash-slot, and return NULL
	 *  when the slot not exists
	 */
	redis_client_pool* peek_slot(int slot);

	/**
	 * ̬ùϣֵӦ redis ַúʱڲ߳;
	 * dynamicly set redis-server addr with one slot, which is protected
	 * by thread mutex internal, no one will be set if the slot were
	 * beyyond the max hash-slot
	 * @param slot {int} ϣֵ;
	 *  the hash-slot
	 * @param addr {const char*} redis ַ;
	 *  one redis-server addr
	 */
	void set_slot(int slot, const char* addr);

	/**
	 *  redis Ⱥеһ㣬ԶеĹϣ۶ӦĽַ
	 * according one node of the cluster, auto find all nodes with all
	 * slots range
	 * @param addr {const char*} Ⱥеһַʽ ip:port
	 *  on server node's addr of the cluster, addr format is "ip:port"
	 * @param max_conns {size_t} Ⱥÿӳص
	 *  the max connections limit for each connection pool
	 * @param conn_timeout {int} ӳʱʱ
	 *  set the connection timeout
	 * @param rw_timeout {int} IO дʱʱ
	 *  set the network io timeout
	 */
	void set_all_slot(const char* addr, size_t max_conns,
		int conn_timeout = 30, int rw_timeout = 30);

	/**
	 * ̬ϣ۶Ӧ redis ַԱ¼λã
	 * ڲ߳;
	 * dynamicly remove one slot and redis-server addr mapping, which is
	 * protected by thread mutex
	 * @param slot {int} ϣֵ;
	 *  hash-slot value
	 */
	void clear_slot(int slot);

	/**
	 * ùϣֵ;
	 * get the max hash-slot
	 * @return {int}
	 */
	int get_max_slot() const
	{
		return max_slot_;
	}

	//////////////////////////////////////////////////////////////////////
	/**
	 * ЭضķֵĬֵΪ 15;
	 * set redirect limit for MOVE/ASK, default is 15
	 * @param max {int} ضֵֻеֵ > 0 ʱЧ;
	 *  the redirect times limit for MOVE/ASK commands
	 */
	void set_redirect_max(int max);

	/**
	 * Эضķֵ;
	 * get redirect limit of MOVE/ASK commands in one redis redirect process
	 * @return {int}
	 */
	int get_redirect_max() const
	{
		return redirect_max_;
	}

	/**
	 * ض >= 2 ʱߵʱ()ĬֵΪ 100 룬
	 * ôǵһ redis ߺӽΪҪ
	 * ʱ( redis.conf е cluster-node-timeout )
	 * ΪضĴΧڲҪȴӽΪ;
	 * if redirect happenning more than 2 in one redis command process,
	 * the process can sleep for a one avoiding redirect too fast, you
	 * can set the waiting time with microsecond here, default value is
	 * 100 microseconds; this only happends when redis-server died.
	 * @param n {int} ÿضʱϢʱ()ĬֵΪ 100 ;
	 * microseonds to sleep when redirect times are more than 2,
	 * default is 100 ms
	 */
	void set_redirect_sleep(int n);

	/**
	 *  set_redirect_sleep õĻĬϵʱ;
	 * get sleep time set by set_redirect_sleep function
	 * @return {int} λΪ;
	 *  return sleep value in microsecond
	 */
	int get_redirect_sleep() const
	{
		return redirect_sleep_;
	}

	/**
	 *  SSL ͨŷʽµþڲȱʡֵΪ NULL SSL 
	 * öڲл SSL ͨŷʽ
	 * set SSL communication with Redis-server if ssl_conf not NULL
	 * @param ssl_conf {sslbase_conf*}
	 * @return {redis_client_cluster&}
	 */
	redis_client_cluster& set_ssl_conf(sslbase_conf* ssl_conf);

	/**
	 * ĳ redis Ӧ
	 * set the password of one redis-server
	 * @param addr {const char*} ָĳ redis ַòֵΪ
	 *  default ʱָ˼Ⱥ redis ȱʡ
	 *  the specified redis-server's addr, the default password of all
	 *  redis-server will be set when the addr's value is 'default'
	 * @param pass {const char*} ָ redis 
	 *  the password of the specified redis-server
	 * @return {redis_client_cluster&}
	 */
	redis_client_cluster& set_password(const char* addr, const char* pass);

	/**
	 *  redis ȺзڵĶձ
	 * get all passwords of the redis cluster
	 * @return {const std::map<string, string>&}
	 */
	const std::map<string, string>& get_passwords(void) const
	{
		return passwds_;
	}

	/**
	 * øַ redis ڵ룬 NULL ʾδ
	 * get the connection password of the specified addr for one redis,
	 * NULL will be returned if password wasn't set
	 * @param addr {const char*}
	 * @return {const char*} return the specified node's connection password,
	 *  NULL returned if no password been set
	 */
	const char* get_password(const char* addr) const;

	/**
	 * ضĿ redis ڵ
	 * @param addr {const char*} Ŀ redis ַ
	 * @param max_conns {size_t} ӳ
	 * @return {redis_client*} Ŀ redis ڵͨŶ
	 */
	redis_client* redirect(const char* addr, size_t max_conns);

	/**
	 *  redis ȺĲۺŻӶ
	 * @param slot {int} redis ȺֵӦĴ洢۲ۺ
	 * @return {redis_client*} Ŀ redis ڵͨŶ
	 */
	redis_client* peek_conn(int slot);

protected:
	/**
	 * ി麯ӳض󣬸úغɻӼIO ʱʱ
	 * virtual function of base class, which is used to create
	 * the connection pool
	 * @param addr {const char*} ַʽip:port;
	 * the server addr for the connection pool, such as ip:port
	 * @param count {size_t} ӳصĴСƣֵû 0 ʱû
	 * the max connections in one connection pool, if it's 0 there
	 * is no limit of the connections pool.
	 * @param idx {size_t} ӳضڼе±λ( 0 ʼ);
	 * the index of the connection pool in pool array
	 */
	connect_pool* create_pool(const char* addr, size_t count, size_t idx);

private:
	int max_slot_;
	const char** slot_addrs_;
	std::vector<char*> addrs_;
	int redirect_max_;
	int redirect_sleep_;
	std::map<string, string> passwds_;
	sslbase_conf* ssl_conf_;

	const char* get_addr(dbuf_pool* dbuf, const char* info);

	redis_client* reopen(redis_command& cmd, redis_client* conn);
	redis_client* move(redis_command& cd, redis_client* conn, 
			const char* ptr, int nretried);
	redis_client* ask(redis_command& cd, redis_client* conn, 
			const char* ptr, int nretried);
	redis_client* cluster_down(redis_command& cd, redis_client* conn, 
			const char* ptr, int nretried);

public:
	const redis_result* run(redis_command& cmd, size_t nchild,
			int* timeout = NULL);
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_REDIS_DISABLE)
